/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.storage;

import android.support.annotation.NonNull;
import android.util.Base64;
import com.ca.mas.core.security.DefaultEncryptionProvider;
import com.ca.mas.core.security.EncryptionProvider;
import com.ca.mas.core.security.MASSecretKeyProvider;
import com.ca.mas.core.storage.sharedstorage.MASSharedStorage;
import com.ca.mas.foundation.MAS;
import java.nio.charset.Charset;

public class MASSecureSharedStorage
extends MASSharedStorage {
    private boolean secureMode;
    private MASSecretKeyProvider secretKeyProvider;

    public MASSecureSharedStorage(@NonNull String accountName, boolean activeSecureMode, boolean sharedMode, boolean storageMode) {
        super(accountName, sharedMode, storageMode);
        this.secureMode = activeSecureMode;
        this.secretKeyProvider = new MASSecretKeyProvider(MAS.getContext(), accountName);
    }

    @Override
    public void save(@NonNull String key, String value) {
        this.preconditionCheck(key);
        Charset charSet = Charset.forName("utf-8");
        byte[] encrypted = this.getEncryptionProvider().encrypt(value.getBytes(charSet));
        super.save(key, Base64.encodeToString((byte[])encrypted, (int)2));
    }

    @Override
    public void save(@NonNull String key, byte[] value) {
        this.preconditionCheck(key);
        super.save(key, this.getEncryptionProvider().encrypt(value));
    }

    @Override
    public String getString(String key) {
        this.preconditionCheck(key);
        String retValue = super.getString(key);
        if (retValue != null) {
            Charset charSet = Charset.forName("utf-8");
            try {
                byte[] encodedbytes = this.getEncryptionProvider().decrypt(Base64.decode((String)retValue, (int)2));
                retValue = new String(encodedbytes, charSet);
            }
            catch (Exception e) {
                this.delete(key);
                retValue = null;
            }
        }
        return retValue;
    }

    @Override
    public byte[] getBytes(String key) {
        this.preconditionCheck(key);
        byte[] retValue = super.getBytes(key);
        if (retValue != null) {
            try {
                retValue = this.getEncryptionProvider().decrypt(retValue);
            }
            catch (Exception e) {
                this.delete(key);
                retValue = null;
            }
        }
        return retValue;
    }

    @Override
    protected EncryptionProvider getEncryptionProvider() {
        EncryptionProvider encProvider = this.secureMode ? new DefaultEncryptionProvider(MAS.getContext(), this.secretKeyProvider){

            @Override
            protected String getKeyAlias() {
                return "com.ca.mas.ACCOUNT_MANAGER_SECRET";
            }
        } : super.getEncryptionProvider();
        return encProvider;
    }
}

