/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.registration;

import android.support.annotation.NonNull;
import android.util.Base64;
import android.util.Log;
import com.ca.mas.core.cert.CertUtils;
import com.ca.mas.core.client.ServerClient;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.io.Charsets;
import com.ca.mas.core.io.IoUtils;
import com.ca.mas.core.registration.RegistrationException;
import com.ca.mas.core.registration.RegistrationServerException;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASRequestBody;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASResponseBody;
import java.io.IOException;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;

public class RegistrationClient
extends ServerClient {
    public RegistrationClient(MssoContext mssoContext) {
        super(mssoContext);
    }

    public DeviceRegistrationResult registerDevice(@NonNull byte[] certificateSigningRequest, @NonNull MASRequest request, @NonNull String clientId, @NonNull String clientSecret, @NonNull String deviceId, @NonNull String deviceName, boolean createSession) throws RegistrationException, RegistrationServerException {
        MASResponse response;
        if (request.getGrantProvider().getCredentials(this.mssoContext) == null) {
            throw new NullPointerException("credentials");
        }
        URI tokenUri = request.getGrantProvider().getRegistrationPath(this.mssoContext);
        if (tokenUri == null) {
            throw new RegistrationException(120004, "No device registration URL is configured");
        }
        MASRequest.MASRequestBuilder builder = new MASRequest.MASRequestBuilder(tokenUri);
        MASAuthCredentials creds = request.getGrantProvider().getCredentials(this.mssoContext);
        Map<String, List<String>> headers = creds.getHeaders();
        if (headers != null) {
            for (String key : headers.keySet()) {
                if (headers.get(key) == null) continue;
                for (String value : headers.get(key)) {
                    builder.header(key, value);
                }
            }
        }
        builder.header("client-authorization", "Basic " + IoUtils.base64(clientId + ":" + clientSecret, Charsets.ASCII));
        builder.header("device-id", IoUtils.base64(deviceId, Charsets.ASCII));
        builder.header("device-name", IoUtils.base64(deviceName, Charsets.ASCII));
        if (request.getGrantProvider().isSessionSupported()) {
            builder.header("create-session", Boolean.toString(createSession));
        }
        builder.header("cert-format", "pem");
        builder.post(MASRequestBody.byteArrayBody(Base64.encode((byte[])certificateSigningRequest, (int)11)));
        MAGHttpClient httpClient = this.mssoContext.getMAGHttpClient();
        try {
            response = httpClient.execute(builder.build());
        }
        catch (IOException e) {
            throw new RegistrationException(120004, "Unable to post to register_device: " + e.getMessage(), e);
        }
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)String.format("%s response with status: %d", request.getURL(), response.getResponseCode()));
        }
        if (response.getResponseCode() != 200) {
            throw ServerClient.createServerException(response, RegistrationServerException.class);
        }
        final DeviceStatus deviceStatus = RegistrationClient.findDeviceStatus(response);
        final String magIdentifier = this.findMagIdentifier(response);
        final IdToken idToken = this.findIdToken(response, createSession && request.getGrantProvider().isSessionSupported());
        MASResponseBody responseEntity = response.getBody();
        if (responseEntity == null) {
            throw new RegistrationException(120006, "register_device response did not contain an entity");
        }
        byte[] chainBytes = responseEntity.getRawContent();
        if (chainBytes.length < 1) {
            throw new RegistrationException(120006, "register_device response was empty");
        }
        final X509Certificate[] chain = CertUtils.decodeCertificateChain(chainBytes);
        if (chain.length < 1) {
            throw new RegistrationException(120006, "register_device response did not include a certificate chain");
        }
        return new DeviceRegistrationResult(){

            @Override
            public DeviceStatus getDeviceStatus() {
                return deviceStatus;
            }

            @Override
            public String getMagIdentifier() {
                return magIdentifier;
            }

            @Override
            public IdToken getIdToken() {
                return idToken;
            }

            @Override
            public X509Certificate[] getClientCertificateChain() {
                return chain;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DeviceStatus findDeviceStatus(MASResponse response) throws RegistrationException {
        List<String> headers = response.getHeaders().get("device-status");
        if (headers == null) throw new RegistrationException(120006, "register_device response did not include exactly one device status header.");
        if (headers.size() != 1) throw new RegistrationException(120006, "register_device response did not include exactly one device status header.");
        String value = headers.get(0);
        if ("activated".equalsIgnoreCase(value)) {
            return DeviceStatus.ACTIVATED;
        }
        if (!"registered".equalsIgnoreCase(value)) throw new RegistrationException(120006, "register_device response did not include a recognized device status.  Status was: " + value);
        return DeviceStatus.REGISTERED;
    }

    private String findMagIdentifier(MASResponse response) throws RegistrationException {
        String value;
        List<String> headers = response.getHeaders().get("mag-identifier");
        if (headers != null && headers.size() == 1) {
            value = headers.get(0);
            byte[] decoded = Base64.decode((String)value, (int)0);
            if (decoded == null || decoded.length < 1) {
                throw new RegistrationException(120008, "register_device response did not include a valid mag identifier.");
            }
        } else {
            throw new RegistrationException(120008, "register_device response did not include exactly one mag identifier header.");
        }
        String magIdentifier = value;
        return magIdentifier;
    }

    private IdToken findIdToken(MASResponse response, boolean require) throws RegistrationException {
        List<String> idTokens = response.getHeaders().get("id-token");
        List<String> idTokenTypes = response.getHeaders().get("id-token-type");
        if (idTokens == null || idTokens.size() != 1 || idTokenTypes == null || idTokenTypes.size() != 1) {
            if (require) {
                throw new RegistrationException(120006, "register_device response did not include exactly one ID token and ID Token type header.");
            }
            return null;
        }
        String idToken = idTokens.get(0);
        if (idToken.trim().length() < 1) {
            throw new RegistrationException(120006, "register_device response did not include a valid ID token.");
        }
        String idTokenType = idTokenTypes.get(0);
        if (idTokenType.trim().length() < 1) {
            throw new RegistrationException(120006, "register_device response did not include a valid ID token type.");
        }
        return new IdToken(idToken, idTokenType);
    }

    public void removeDeviceRegistration() throws RegistrationException, RegistrationServerException {
        MASResponse response;
        MASRequest.MASRequestBuilder builder = new MASRequest.MASRequestBuilder(this.conf.getTokenUri("msso.url.remove_device_x509")).delete(null);
        MAGHttpClient httpClient = this.mssoContext.getMAGHttpClient();
        try {
            response = httpClient.execute(builder.build());
        }
        catch (IOException e) {
            throw new RegistrationException(120003, "Unable to de-register device: " + e.getMessage(), e);
        }
        if (200 != response.getResponseCode()) {
            throw ServerClient.createServerException(response, RegistrationServerException.class);
        }
    }

    public static interface DeviceRegistrationResult {
        public DeviceStatus getDeviceStatus();

        public String getMagIdentifier();

        public IdToken getIdToken();

        public X509Certificate[] getClientCertificateChain();
    }

    public static enum DeviceStatus {
        ACTIVATED,
        REGISTERED;

    }
}

