/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation.auth;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import android.util.LruCache;
import android.view.View;
import android.widget.ImageView;
import com.ca.mas.core.ent.InvalidResponseException;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.notify.Callback;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MASApplication {
    private static MASApplicationLauncher mLauncher = new MASApplicationLauncher(){

        @Override
        public void onWebAppLaunch(MASApplication application) {
        }
    };

    private MASApplication() {
    }

    public abstract String getIdentifier();

    public abstract String getName();

    public abstract String getIconUrl();

    public abstract String getAuthUrl();

    public abstract String getNativeUri();

    public abstract JSONObject getCustom();

    public static void setApplicationLauncher(MASApplicationLauncher launcher) {
        mLauncher = launcher;
    }

    public abstract void renderEnterpriseIcon(ImageView var1);

    public static void retrieveEnterpriseApps(final MASCallback<List<MASApplication>> callback) {
        String path = MASConfiguration.getCurrentConfiguration().getEndpointPath("msso.url.enterprise_apps");
        try {
            MASRequest r = new MASRequest.MASRequestBuilder(new URI(path)).notifyOnCancel().build();
            MAS.invoke(r, new MASCallback<MASResponse<JSONObject>>(){

                @Override
                public void onSuccess(MASResponse<JSONObject> result) {
                    try {
                        ArrayList<1> applications = new ArrayList<1>();
                        JSONArray apps = result.getBody().getContent().optJSONArray("enterprise-apps");
                        if (apps != null) {
                            for (int i = 0; i < apps.length(); ++i) {
                                JSONObject app = ((JSONObject)apps.get(i)).getJSONObject("app");
                                final String id = app.getString("id");
                                final String name = app.optString("name");
                                final String iconUrl = app.optString("icon_url");
                                final String authUrl = app.optString("auth_url");
                                final String nativeUri = app.optString("native_url");
                                final String custom = app.optString("custom");
                                applications.add(new MASApplication(){

                                    @Override
                                    public String getIdentifier() {
                                        return id;
                                    }

                                    @Override
                                    public String getName() {
                                        return name;
                                    }

                                    @Override
                                    public String getIconUrl() {
                                        return iconUrl;
                                    }

                                    @Override
                                    public String getAuthUrl() {
                                        return authUrl;
                                    }

                                    @Override
                                    public String getNativeUri() {
                                        return nativeUri;
                                    }

                                    @Override
                                    public JSONObject getCustom() {
                                        block3: {
                                            if (custom != null) {
                                                try {
                                                    return new JSONObject(custom);
                                                }
                                                catch (JSONException e) {
                                                    if (!MAS.DEBUG) break block3;
                                                    Log.e((String)"MAS", (String)e.getMessage(), (Throwable)e);
                                                }
                                            }
                                        }
                                        return null;
                                    }

                                    @Override
                                    public void renderEnterpriseIcon(ImageView imageView) {
                                        new ImageFetcher(imageView).execute(new Object[]{this.getIconUrl()});
                                        final 1 t = this;
                                        imageView.setOnClickListener(new View.OnClickListener(){

                                            public void onClick(View v) {
                                                if (this.getNativeUri() != null && this.getNativeUri().length() > 0) {
                                                    if (mLauncher != null) {
                                                        mLauncher.onNativeAppLaunch(t);
                                                    }
                                                    return;
                                                }
                                                if (this.getAuthUrl() != null && this.getAuthUrl().length() > 0 && mLauncher != null) {
                                                    mLauncher.onWebAppLaunch(t);
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                        }
                        Callback.onSuccess(callback, applications);
                    }
                    catch (Exception e) {
                        if (e.getCause() != null && e.getCause() instanceof JSONException) {
                            Callback.onError(callback, new InvalidResponseException(e.getCause()));
                            return;
                        }
                        Callback.onError(callback, e);
                    }
                }

                @Override
                public void onError(Throwable e) {
                    Callback.onError(callback, e);
                }
            });
        }
        catch (URISyntaxException e) {
            Callback.onError(callback, e);
        }
    }

    public static abstract class MASApplicationLauncher {
        public void onNativeAppLaunch(MASApplication application) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)application.getNativeUri()));
            intent.setFlags(0x10000000);
            try {
                MAS.getContext().startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                if (MAS.DEBUG) {
                    Log.e((String)"MAS", (String)e.getMessage(), (Throwable)e);
                }
                throw e;
            }
        }

        public abstract void onWebAppLaunch(MASApplication var1);
    }

    private static class ImageFetcher
    extends AsyncTask<Object, Object, Object> {
        private static LruCache<String, Bitmap> cache = new LruCache((int)(Runtime.getRuntime().maxMemory() / 1024L / 24L));
        ImageView imageView;
        private HttpURLConnection connection;
        private InputStream is;
        private Bitmap bitmap;

        public ImageFetcher(ImageView mImageView) {
            this.imageView = mImageView;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground(Object ... params) {
            Bitmap cached = (Bitmap)cache.get((Object)((String)params[0]));
            if (cached != null) {
                return cached;
            }
            try {
                URL url = new URL((String)params[0]);
                this.connection = (HttpURLConnection)url.openConnection();
                this.connection.setDoInput(true);
                this.connection.setUseCaches(true);
                this.connection.connect();
                this.is = this.connection.getInputStream();
                this.bitmap = BitmapFactory.decodeStream((InputStream)this.is);
                this.is.close();
            }
            catch (Exception e) {
                if (MAS.DEBUG) {
                    Log.e((String)"MAS", (String)"Error in downloading the image", (Throwable)e);
                }
            }
            finally {
                block17: {
                    try {
                        if (this.is != null) {
                            this.is.close();
                        }
                        if (this.connection != null) {
                            this.connection.disconnect();
                        }
                    }
                    catch (IOException e) {
                        if (!MAS.DEBUG) break block17;
                        Log.w((String)"MAS", (String)"Failed to clear up connection.", (Throwable)e);
                    }
                }
            }
            if (this.bitmap != null) {
                cache.put((Object)((String)params[0]), (Object)this.bitmap);
            }
            return this.bitmap;
        }

        protected void onPostExecute(Object result) {
            super.onPostExecute(result);
            if (null != result) {
                this.imageView.setImageBitmap((Bitmap)result);
            }
        }
    }
}

