/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.token;

import android.support.annotation.NonNull;
import android.util.Base64;
import android.util.Log;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.core.token.JWTExpiredException;
import com.ca.mas.core.token.JWTHmac;
import com.ca.mas.core.token.JWTInvalidAUDException;
import com.ca.mas.core.token.JWTInvalidAZPException;
import com.ca.mas.core.token.JWTValidationException;
import com.ca.mas.foundation.MAS;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class JWTValidation {
    private static final String TAG = JWTValidation.class.getName();
    public static final String ALG = "alg";
    public static final String EXP = "exp";
    public static final String AUD = "aud";
    public static final String AZP = "azp";

    public static boolean isIdTokenExpired(@NonNull IdToken idToken) {
        if (idToken.getType().equals("urn:ietf:params:oauth:grant-type:jwt-bearer")) {
            IdTokenDef tokenDef = new IdTokenDef(idToken);
            try {
                JSONObject jsonObject = tokenDef.getPayloadAsJSONObject();
                String expireDateString = jsonObject.getString(EXP);
                return Long.valueOf(expireDateString) < new Date().getTime() / 1000L;
            }
            catch (JSONException e) {
                return true;
            }
        }
        return false;
    }

    public static boolean validateIdToken(IdToken idToken, String deviceIdentifier, String clientId, String clientSecret) throws JWTValidationException {
        boolean isValid = false;
        IdTokenDef idTokenDef = new IdTokenDef(idToken);
        boolean payloadValid = JWTValidation.validateJwtPayload(idTokenDef, deviceIdentifier, clientId);
        String algorithm = JWTValidation.getAlgorithm(new String(Base64.decode((byte[])idTokenDef.getHeader(), (int)8)));
        boolean signatureValid = false;
        boolean idTokenValidationEnabled = MAS.isIdTokenValidationEnabled();
        if (algorithm != null && idTokenValidationEnabled) {
            if (algorithm.equals(Algorithm.HS256.toString())) {
                signatureValid = JWTHmac.validateHMacSignature(idTokenDef.getHeader(), idTokenDef.getPayload(), clientSecret.getBytes(), idTokenDef.getSignature());
            }
            if (algorithm.equals(Algorithm.RS256.toString())) {
                throw new JWTValidationException(13101);
            }
        }
        if (!idTokenValidationEnabled) {
            signatureValid = true;
        }
        isValid = payloadValid & signatureValid;
        return isValid;
    }

    private static String getAlgorithm(String header) throws JWTValidationException {
        try {
            JSONObject jsonObject = new JSONObject(header);
            return jsonObject.getString(ALG);
        }
        catch (JSONException e) {
            Log.w((String)TAG, (String)"JWT header is not JSON Object");
            throw new JWTValidationException(13101, e.getMessage(), e);
        }
    }

    private static boolean validateJwtPayload(IdTokenDef idTokenDef, String deviceIdentifier, String clientId) throws JWTValidationException {
        try {
            JSONObject jsonObject = idTokenDef.getPayloadAsJSONObject();
            String expireDateString = jsonObject.getString(EXP);
            String audString = jsonObject.getString(AUD);
            String azpString = jsonObject.getString(AZP);
            if (!audString.equals(clientId)) {
                Log.w((String)TAG, (String)"JWT aud is invalid");
                throw new JWTInvalidAUDException("Failed to validate JWT Token: \"aud\" doesn't match client_id!");
            }
            if (!azpString.equals(deviceIdentifier)) {
                Log.w((String)TAG, (String)"JWT azp is invalid");
                throw new JWTInvalidAZPException("Failed to validate JWT Token: \"azp\" doesn't match device identifier!");
            }
            if (Long.valueOf(expireDateString) < new Date().getTime() / 1000L) {
                Log.w((String)TAG, (String)"JWT expired");
                throw new JWTExpiredException("Failed to validate JWT Token: token expired!");
            }
        }
        catch (JSONException e) {
            Log.w((String)TAG, (String)"JWT payload is not valid JSON object");
            throw new JWTValidationException(13101, e.getMessage(), e);
        }
        return true;
    }

    private static class IdTokenDef {
        byte[] header;
        byte[] payload;
        byte[] signature;

        public IdTokenDef(@NonNull IdToken idToken) {
            byte[] token = idToken.getValue().getBytes();
            byte[][] splitToken = this.split(token);
            this.header = splitToken[0];
            this.payload = splitToken[1];
            this.signature = null;
            if (splitToken.length == 3) {
                this.signature = splitToken[2];
            }
        }

        public byte[] getHeader() {
            return this.header;
        }

        public byte[] getSignature() {
            return this.signature;
        }

        public byte[] getPayload() {
            return this.payload;
        }

        public JSONObject getPayloadAsJSONObject() throws JSONException {
            byte[] decodedPayload = Base64.decode((byte[])this.payload, (int)8);
            String payloadData = new String(decodedPayload);
            return new JSONObject(payloadData);
        }

        private byte[][] split(byte[] token) {
            String tokenString = new String(token);
            String[] tokenParts = tokenString.split("[.]");
            if (tokenParts.length < 2 || tokenParts.length > 3) {
                return null;
            }
            byte[][] splitBytes = new byte[tokenParts.length][];
            splitBytes[0] = new byte[tokenParts[0].getBytes().length];
            splitBytes[1] = new byte[tokenParts[1].getBytes().length];
            System.arraycopy(tokenParts[0].getBytes(), 0, splitBytes[0], 0, tokenParts[0].getBytes().length);
            System.arraycopy(tokenParts[1].getBytes(), 0, splitBytes[1], 0, tokenParts[1].getBytes().length);
            if (splitBytes.length == 3) {
                splitBytes[2] = new byte[tokenParts[2].getBytes().length];
                System.arraycopy(tokenParts[2].getBytes(), 0, splitBytes[2], 0, tokenParts[2].getBytes().length);
            }
            return splitBytes;
        }
    }

    public static enum Algorithm {
        HS256(1),
        RSA(2),
        RS256(3);

        private int value;

        private Algorithm(int value) {
            this.value = value;
        }
    }
}

