/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.store;

import android.os.Build;
import android.util.Log;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.core.datasource.DataSource;
import com.ca.mas.core.datasource.DataSourceException;
import com.ca.mas.core.datasource.DataSourceFactory;
import com.ca.mas.core.datasource.KeystoreDataSource;
import com.ca.mas.core.datasource.MASSecureStorageDataSource;
import com.ca.mas.core.datasource.StringDataConverter;
import com.ca.mas.core.store.ClientCredentialContainer;
import com.ca.mas.core.store.ClientCredentialStorage;
import com.ca.mas.core.store.DefaultTokenManager;
import com.ca.mas.core.store.OAuthTokenContainer;
import com.ca.mas.core.store.PrivateTokenStorage;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.foundation.MAS;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageProvider {
    private StorageConfig mStorageConfig;
    private TokenManager tokenManager;
    private OAuthTokenContainer oAuthTokenContainer;
    private ClientCredentialContainer clientCredentialContainer;
    private static StorageProvider instance;

    private StorageProvider(ConfigurationProvider configurationProvider) {
        this.mStorageConfig = new StorageConfig(configurationProvider);
        this.tokenManager = this.createTokenManager();
        this.oAuthTokenContainer = this.createOAuthTokenContainer();
        this.clientCredentialContainer = this.createClientCredentialContainer();
    }

    public static synchronized StorageProvider getInstance() {
        if (instance == null) {
            if (ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider() == null) {
                throw new IllegalStateException("ConfigurationManager not initialized.");
            }
            instance = new StorageProvider(ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider());
        }
        return instance;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public OAuthTokenContainer getOAuthTokenContainer() {
        return this.oAuthTokenContainer;
    }

    public ClientCredentialContainer getClientCredentialContainer() {
        return this.clientCredentialContainer;
    }

    public void reset() {
        instance = null;
    }

    private TokenManager createTokenManager() {
        JSONObject params;
        block2: {
            ConfigurationProvider provider = ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider();
            params = new JSONObject();
            try {
                params = new JSONObject(this.mStorageConfig.getConfig().toString());
                params.put("share", provider.getProperty("msso.sso.enabled"));
            }
            catch (JSONException e) {
                if (!MAS.DEBUG) break block2;
                Log.w((String)"MAS", (String)("failed to set sharing property " + (Object)((Object)e)));
            }
        }
        DataSource storage = DataSourceFactory.getStorage(ConfigurationManager.getInstance().getContext(), this.mStorageConfig.getStorageClass(), params, null);
        return new DefaultTokenManager(storage);
    }

    private OAuthTokenContainer createOAuthTokenContainer() {
        DataSource storage = DataSourceFactory.getStorage(ConfigurationManager.getInstance().getContext(), this.mStorageConfig.getStorageClass(), this.mStorageConfig.getConfig(), new StringDataConverter());
        return new PrivateTokenStorage(storage);
    }

    private ClientCredentialContainer createClientCredentialContainer() {
        DataSource storage = DataSourceFactory.getStorage(ConfigurationManager.getInstance().getContext(), this.mStorageConfig.getStorageClass(), this.mStorageConfig.getConfig(), new StringDataConverter());
        return new ClientCredentialStorage(storage);
    }

    public boolean hasValidStore() {
        DataSource temp = DataSourceFactory.getStorage(ConfigurationManager.getInstance().getContext(), this.mStorageConfig.getStorageClass(), this.mStorageConfig.getConfig(), new StringDataConverter());
        return temp != null && temp.isReady();
    }

    private static class StorageConfig {
        Class storageClass;
        JSONObject config;
        static final String PROP_STORAGE_CLASS = "class";
        static final String PROP_SHARE_STATUS = "share";

        StorageConfig(ConfigurationProvider configurationProvider) {
            JSONObject storageJson = (JSONObject)configurationProvider.getProperty("msso.storage");
            if (storageJson == null) {
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)"No storage configuration found in JSON config, falling back to DEFAULT ");
                }
                this.storageClass = Build.VERSION.SDK_INT < 28 ? KeystoreDataSource.class : MASSecureStorageDataSource.class;
                this.config = new JSONObject();
            } else {
                try {
                    this.storageClass = Class.forName("" + storageJson.get(PROP_STORAGE_CLASS));
                    this.config = storageJson;
                }
                catch (ClassNotFoundException e) {
                    throw new DataSourceException(String.format("Provided Storage configuration %s cannot be found ", storageJson.toString()), e);
                }
                catch (JSONException e) {
                    throw new DataSourceException("Invalid Storage Config", e);
                }
            }
        }

        Class getStorageClass() {
            return this.storageClass;
        }

        JSONObject getConfig() {
            return this.config;
        }
    }
}

