/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.service;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import com.ca.mas.core.MAGResultReceiver;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.request.internal.AuthenticateRequest;
import com.ca.mas.core.service.MssoActiveQueue;
import com.ca.mas.core.service.MssoRequest;
import com.ca.mas.core.service.MssoRequestQueue;
import com.ca.mas.core.service.MssoResponse;
import com.ca.mas.core.service.MssoResponseQueue;
import com.ca.mas.core.service.MssoService;
import com.ca.mas.core.util.Functions;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASUser;

public class MssoClient {
    private final Context appContext;
    private final MssoContext mssoContext;

    public MssoClient(MssoContext mssoContext, Context sysContext) {
        if (sysContext == null) {
            throw new NullPointerException("sysContext");
        }
        if (mssoContext == null) {
            throw new NullPointerException("mssoContext");
        }
        this.mssoContext = mssoContext;
        this.appContext = sysContext.getApplicationContext();
    }

    public long processRequest(MASRequest request, ResultReceiver resultReceiver) {
        MssoRequest mssoRequest = new MssoRequest(this, this.mssoContext, request, resultReceiver);
        MssoRequestQueue.getInstance().addRequest(mssoRequest);
        long requestId = mssoRequest.getId();
        Intent intent = new Intent("com.ca.mas.core.service.action.PROCESS_REQUEST");
        intent.putExtra("com.ca.mas.core.service.req.extra.requestId", requestId);
        MssoService.enqueueWork(this.appContext, intent);
        return requestId;
    }

    private Intent createAuthenticationIntent(MASAuthCredentials credentials, MAGResultReceiver resultReceiver) {
        MssoRequest mssoRequest = new MssoRequest(this, this.mssoContext, new AuthenticateRequest(), resultReceiver);
        MssoRequestQueue.getInstance().addRequest(mssoRequest);
        long requestId = mssoRequest.getId();
        Intent intent = new Intent("com.ca.mas.core.service.action.CREDENTIALS_OBTAINED");
        intent.putExtra("com.ca.mas.core.service.req.extra.credentials", (Parcelable)credentials);
        intent.putExtra("com.ca.mas.core.service.req.extra.requestId", requestId);
        return intent;
    }

    public void authenticate(MASAuthCredentials credentials, final MAGResultReceiver resultReceiver) {
        final Intent intent = this.createAuthenticationIntent(credentials, resultReceiver);
        MASUser user = MASUser.getCurrentUser();
        if (user != null) {
            user.logout(true, new MASCallback<Void>(){

                @Override
                public void onSuccess(Void result) {
                    MssoService.enqueueWork(MssoClient.this.appContext, intent);
                }

                @Override
                public void onError(Throwable e) {
                    resultReceiver.onError(new MAGError(e));
                }
            });
        } else {
            MssoService.enqueueWork(this.appContext, intent);
        }
    }

    public void processPendingRequests() {
        Intent intent = new Intent("com.ca.mas.core.service.action.PROCESS_REQUEST");
        intent.putExtra("com.ca.mas.core.service.req.extra.requestId", -1L);
        MssoService.enqueueWork(this.appContext, intent);
    }

    public static MASResponse takeMAGResponse(long requestId) {
        return MssoResponseQueue.getInstance().takeResponse(requestId).getHttpResponse();
    }

    public void cancelRequest(long requestId, Bundle data) {
        MssoRequest request = null;
        MssoResponseQueue.getInstance().takeResponse(requestId);
        request = MssoRequestQueue.getInstance().takeRequest(requestId);
        if (request == null) {
            request = MssoActiveQueue.getInstance().takeRequest(requestId);
        }
        if (request != null && request.getResultReceiver() != null) {
            request.getResultReceiver().send(2, data);
        }
    }

    public void cancelAll(Bundle data) {
        MssoRequestQueue.getInstance().removeMatching(new Functions.Unary<Boolean, MssoRequest>(){

            @Override
            public Boolean call(MssoRequest mssoRequest) {
                return mssoRequest.getCreator() == MssoClient.this;
            }
        }, data);
        MssoResponseQueue.getInstance().removeMatching(new Functions.Unary<Boolean, MssoResponse>(){

            @Override
            public Boolean call(MssoResponse mssoResponse) {
                return mssoResponse.getRequest().getCreator() == MssoClient.this;
            }
        }, data);
        MssoActiveQueue.getInstance().removeMatching(new Functions.Unary<Boolean, MssoRequest>(){

            @Override
            public Boolean call(MssoRequest mssoRequest) {
                return mssoRequest.getCreator() == MssoClient.this;
            }
        }, data);
    }
}

