/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.app.KeyguardManager;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.core.security.EncryptionProvider;
import com.ca.mas.core.security.KeyStoreKeyStorageProvider;
import com.ca.mas.core.security.SharedPreferencesKeyStorageProvider;
import com.ca.mas.core.util.KeyUtilsSymmetric;
import com.ca.mas.foundation.MAS;
import javax.crypto.SecretKey;

public class ScreenLockEncryptionProvider
implements EncryptionProvider {
    protected Context ctx = null;
    private String keyAlias = "com.ca.mas.SCREEN_LOCK_SECRET";
    private KeyStoreKeyStorageProvider keyStorageProvider = null;

    public ScreenLockEncryptionProvider(@NonNull Context ctx) {
        this.ctx = ctx;
        this.keyStorageProvider = new SharedPreferencesKeyStorageProvider(ctx);
    }

    public ScreenLockEncryptionProvider(@NonNull Context ctx, KeyStoreKeyStorageProvider keyStorageProvider) {
        this.ctx = ctx;
        this.keyStorageProvider = keyStorageProvider;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        SecretKey secretKey = this.getKey(this.keyAlias);
        return KeyUtilsSymmetric.encrypt(data, secretKey, this.keyAlias);
    }

    @Override
    public byte[] decrypt(byte[] encryptedData) {
        SecretKey secretKey = this.getKey(this.keyAlias);
        return KeyUtilsSymmetric.decrypt(encryptedData, secretKey, this.keyAlias);
    }

    protected SecretKey getKey(String alias) {
        if (!this.deviceHasScreenLock()) {
            Log.w((String)"MAS", (String)"ScreenLockEncryptionProvider getKey there is no screen lock (pin/swipe/password), so the key will be deleted");
            try {
                KeyUtilsSymmetric.deleteKey(alias);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.keyStorageProvider.removeKey(alias);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (MAS.DEBUG) {
                Log.d((String)"MAS", (String)"ScreenLockEncryptionProvider getKey there is no screen lock (pin/swipe/password), so the encryption key has been deleted");
            }
            throw new RuntimeException("ScreenLockEncryptionProvider getKey there is no screen lock (pin/swipe/password), so the encryption key has been deleted");
        }
        return this.keyStorageProvider.getKey(this.keyAlias, true);
    }

    protected boolean deviceHasScreenLock() {
        try {
            KeyguardManager km = (KeyguardManager)this.ctx.getSystemService("keyguard");
            if (Build.VERSION.SDK_INT >= 23) {
                return km.isDeviceSecure();
            }
            return km.isKeyguardSecure();
        }
        catch (Exception x) {
            Log.e((String)"MAS", (String)"Exception determining if screen has a lock (pin/swipe/password), will be assuming it does not", (Throwable)x);
            return false;
        }
    }
}

