/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.util.Log;
import com.ca.mas.core.security.GenerateKeyAttribute;
import com.ca.mas.core.security.KeyStoreException;
import com.ca.mas.core.security.KeyStoreRepository;
import com.ca.mas.foundation.MAS;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import sun.security.pkcs.PKCS10;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;

abstract class AndroidKeyStoreRepository
extends KeyStoreRepository {
    private static final int MAX_CHAIN = 9;
    private static final String ANDROID_KEY_STORE = "AndroidKeyStore";

    AndroidKeyStoreRepository() {
    }

    @Override
    public Key getPrivateKey(String alias) throws KeyStoreException {
        try {
            KeyStore keyStore = this.getKeyStore();
            return keyStore.getKey(alias, null);
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public Key getPublicKey(String alias) throws KeyStoreException {
        try {
            KeyStore keyStore = this.getKeyStore();
            Certificate cert = keyStore.getCertificate(alias);
            if (cert != null) {
                return cert.getPublicKey();
            }
            return null;
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public void deleteKey(String alias) {
        try {
            KeyStore keyStore = this.getKeyStore();
            keyStore.deleteEntry(alias);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    abstract AlgorithmParameterSpec getAlgorithmParameterSpec(String var1, GenerateKeyAttribute var2) throws KeyStoreException;

    @Override
    public KeyPair createPrivateKey(String alias, GenerateKeyAttribute attributes) throws KeyStoreException {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA", ANDROID_KEY_STORE);
            keyPairGenerator.initialize(this.getAlgorithmParameterSpec(alias, attributes));
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
        return keyPairGenerator.generateKeyPair();
    }

    @Override
    public void saveCertificateChain(String alias, X509Certificate[] chain) throws KeyStoreException {
        try {
            int i;
            KeyStore keyStore = this.getKeyStore();
            for (i = 1; i <= 9; ++i) {
                keyStore.deleteEntry(alias + i);
            }
            for (i = 0; i < chain.length; ++i) {
                keyStore.setCertificateEntry(alias + (i + 1), chain[i]);
            }
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
    }

    private KeyStore getKeyStore() throws java.security.KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
        keyStore.load(null);
        return keyStore;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        try {
            X509Certificate[] returnChain = null;
            KeyStore keyStore = this.getKeyStore();
            int numInChain = 0;
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                int numAlias;
                String aliasFound = e.nextElement();
                if (!aliasFound.startsWith(alias) || (numAlias = Integer.parseInt(aliasFound.replace(alias, ""))) <= numInChain) continue;
                numInChain = numAlias;
            }
            if (numInChain > 0) {
                returnChain = new X509Certificate[numInChain];
                for (int i = 0; i < numInChain; ++i) {
                    returnChain[i] = (X509Certificate)keyStore.getCertificate(alias + (i + 1));
                }
            }
            return returnChain;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void deleteCertificateChain(String alias) {
        try {
            KeyStore keyStore = this.getKeyStore();
            for (int i = 1; i <= 9; ++i) {
                keyStore.deleteEntry(alias + i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public byte[] generateCertificateSigningRequest(String commonName, String deviceId, String deviceName, String organization, PrivateKey privateKey, PublicKey publicKey) throws CertificateException {
        try {
            PKCS10 pkcs10 = new PKCS10(publicKey);
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            X500Name x500Name = new X500Name("cn=" + commonName + ", ou=" + deviceId + ", dc=" + deviceName + ", o=" + organization);
            pkcs10.encodeAndSign(new X500Signer(signature, x500Name));
            return pkcs10.getEncoded();
        }
        catch (Exception t) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("Unable to generate certificate signing request: " + t), (Throwable)t);
            }
            throw new CertificateException("Unable to generate certificate signing request: " + t);
        }
    }
}

