/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.policy.AccessTokenAssertion;
import com.ca.mas.core.policy.ClientCredentialAssertion;
import com.ca.mas.core.policy.CustomHeaderAssertion;
import com.ca.mas.core.policy.DeviceRegistrationAssertion;
import com.ca.mas.core.policy.LocationAssertion;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.ResponseRecoveryAssertion;
import com.ca.mas.core.policy.SecureLockAssertion;
import com.ca.mas.core.policy.StorageReadyAssertion;
import com.ca.mas.core.policy.TelephoneAssertion;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolicyManager {
    private final MssoContext mssoContext;
    private final Object policySync = new Object();
    private final Map<String, List<MssoAssertion>> policys = new HashMap<String, List<MssoAssertion>>();
    private final StorageReadyAssertion storageReadyAssertion;
    private final SecureLockAssertion secureLockAssertion;
    private final ClientCredentialAssertion clientCredentialAssertion;
    private final DeviceRegistrationAssertion deviceRegistrationAssertion;
    private final AccessTokenAssertion accessTokenAssertion;
    private final LocationAssertion locationAssertion;
    private final TelephoneAssertion telephoneAssertion;
    private final CustomHeaderAssertion customHeaderAssertion;
    private final ResponseRecoveryAssertion responseRecoveryAssertion;
    private static final String DEF_KEY = "default";
    private final String endpointPathLogout = MASConfiguration.getCurrentConfiguration().getEndpointPath("msso.url.resource_owner_logout");
    private final String endpointPathRevoke = MASConfiguration.getCurrentConfiguration().getEndpointPath("msso.url.usersession_logout_endpoint_path");

    public PolicyManager(MssoContext mssoContext) {
        ArrayList<MssoAssertion> defaultPolicy = new ArrayList<MssoAssertion>();
        ArrayList<MssoAssertion> logoutPolicy = new ArrayList<MssoAssertion>();
        this.mssoContext = mssoContext;
        this.storageReadyAssertion = new StorageReadyAssertion();
        this.secureLockAssertion = new SecureLockAssertion();
        this.clientCredentialAssertion = new ClientCredentialAssertion();
        this.deviceRegistrationAssertion = new DeviceRegistrationAssertion();
        this.accessTokenAssertion = new AccessTokenAssertion();
        this.locationAssertion = new LocationAssertion();
        this.telephoneAssertion = new TelephoneAssertion();
        this.customHeaderAssertion = new CustomHeaderAssertion();
        this.responseRecoveryAssertion = new ResponseRecoveryAssertion();
        defaultPolicy.add(this.storageReadyAssertion);
        defaultPolicy.add(this.secureLockAssertion);
        defaultPolicy.add(this.clientCredentialAssertion);
        defaultPolicy.add(this.deviceRegistrationAssertion);
        defaultPolicy.add(this.accessTokenAssertion);
        defaultPolicy.add(this.locationAssertion);
        defaultPolicy.add(this.telephoneAssertion);
        defaultPolicy.add(this.customHeaderAssertion);
        defaultPolicy.add(this.responseRecoveryAssertion);
        this.policys.put(DEF_KEY, defaultPolicy);
        logoutPolicy.add(this.storageReadyAssertion);
        logoutPolicy.add(this.secureLockAssertion);
        logoutPolicy.add(this.clientCredentialAssertion);
        logoutPolicy.add(this.locationAssertion);
        logoutPolicy.add(this.responseRecoveryAssertion);
        this.policys.put(this.endpointPathLogout, logoutPolicy);
    }

    public void init(Context sysContext) {
        this.init(sysContext, this.policys.get(DEF_KEY));
    }

    private void init(Context sysContext, List<MssoAssertion> policy) {
        Context appContext = sysContext.getApplicationContext();
        for (MssoAssertion assertion : policy) {
            assertion.init(this.mssoContext, appContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(RequestInfo request, List<MssoAssertion> policy) throws MAGException, MAGServerException {
        Object object = this.policySync;
        synchronized (object) {
            for (MssoAssertion assertion : policy) {
                assertion.processRequest(this.mssoContext, request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(RequestInfo request, MASResponse response, List<MssoAssertion> policy) throws MAGException, MAGServerException {
        Object object = this.policySync;
        synchronized (object) {
            for (MssoAssertion assertion : policy) {
                assertion.processResponse(this.mssoContext, request, response);
            }
        }
    }

    public MASResponse execute(RequestInfo requestInfo, Route<MASResponse> function) throws MAGException, MAGServerException, IOException {
        String requestUrl;
        List<MssoAssertion> activePolicy = this.policys.get(DEF_KEY);
        String string = requestUrl = requestInfo.getRequest().getURL() == null ? "" : requestInfo.getRequest().getURL().toString();
        if (requestUrl.contains(this.endpointPathLogout) || requestUrl.contains(this.endpointPathRevoke)) {
            activePolicy = this.policys.get(this.endpointPathLogout);
        }
        this.processRequest(requestInfo, activePolicy);
        MASResponse response = function.invoke();
        this.processResponse(requestInfo, response, activePolicy);
        return response;
    }

    public void close() {
        this.close(this.policys.get(DEF_KEY));
    }

    private void close(List<MssoAssertion> policy) {
        for (MssoAssertion assertion : policy) {
            assertion.close();
        }
    }

    public static interface Route<R> {
        public R invoke() throws IOException;
    }
}

