/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.context;

import com.ca.mas.core.io.IoUtils;
import com.ca.mas.core.security.KeyStoreException;
import com.ca.mas.core.util.KeyUtilsAsymmetric;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;

public abstract class UniqueIdentifier {
    protected String identifier = "";

    public UniqueIdentifier() throws KeyStoreException, NoSuchAlgorithmException {
        String identifierKey = this.getIdentifierKey();
        PublicKey publicKey = KeyUtilsAsymmetric.getRsaPublicKey(identifierKey);
        if (publicKey == null) {
            KeyUtilsAsymmetric.generateRsaPrivateKey(identifierKey, String.format("CN=%s, OU=%s", identifierKey, "com.ca"), false, false, Integer.MAX_VALUE, false);
            publicKey = KeyUtilsAsymmetric.getRsaPublicKey(identifierKey);
        }
        byte[] encoded = publicKey.getEncoded();
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(encoded);
        byte[] mdBytes = md.digest();
        this.identifier = IoUtils.hexDump(mdBytes);
    }

    public String toString() {
        return this.identifier;
    }

    protected abstract String getIdentifierKey();
}

