/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.context;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.ca.mas.core.EventDispatcher;
import com.ca.mas.core.auth.AuthenticationException;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.core.context.MssoException;
import com.ca.mas.core.datasource.DataSourceException;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.policy.PolicyManager;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.exceptions.CertificateExpiredException;
import com.ca.mas.core.policy.exceptions.InvalidClientCredentialException;
import com.ca.mas.core.policy.exceptions.RetryRequestException;
import com.ca.mas.core.registration.RegistrationClient;
import com.ca.mas.core.request.MAGInternalRequest;
import com.ca.mas.core.request.internal.LocalRequest;
import com.ca.mas.core.store.ClientCredentialContainer;
import com.ca.mas.core.store.OAuthTokenContainer;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.core.store.TokenStoreException;
import com.ca.mas.core.token.ClientCredentials;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.core.token.JWTValidation;
import com.ca.mas.core.token.JWTValidationException;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import java.io.IOException;
import java.util.Date;

public class MssoContext {
    private static final int MAX_REQUEST_ATTEMPTS = 4;
    private Context appContext;
    private ConfigurationProvider configurationProvider;
    private PolicyManager policyManager;
    private TokenManager tokenManager;
    private OAuthTokenContainer privateTokens;
    private ClientCredentialContainer clientCredentialTokens;
    private String deviceName;
    private volatile MAGHttpClient magHttpClient;
    private volatile MASAuthCredentials credentials;
    private static final String MSSO_CONTEXT_NOT_INITIALIZED = "MssoContext not initialized, no token manager.";

    private MssoContext() {
    }

    public static MssoContext newContext() {
        return new MssoContext();
    }

    public boolean isInitialized() {
        return this.configurationProvider != null;
    }

    public void init(Context context) {
        this.appContext = context.getApplicationContext();
        this.configurationProvider = ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider();
        if (this.tokenManager == null) {
            this.tokenManager = StorageProvider.getInstance().getTokenManager();
        }
        if (this.privateTokens == null) {
            this.privateTokens = StorageProvider.getInstance().getOAuthTokenContainer();
        }
        if (this.clientCredentialTokens == null) {
            this.clientCredentialTokens = StorageProvider.getInstance().getClientCredentialContainer();
        }
        if (this.deviceName == null) {
            this.deviceName = Build.MODEL;
        }
    }

    public void initPolicyManager() {
        if (this.policyManager == null) {
            this.policyManager = new PolicyManager(this);
        }
        this.policyManager.init(this.appContext);
    }

    public void close() {
        if (this.policyManager != null) {
            this.policyManager.close();
        }
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    private boolean isSsoEnabled() {
        Boolean ssoEnabled = (Boolean)this.configurationProvider.getProperty("msso.sso.enabled");
        return ssoEnabled != null && ssoEnabled != false;
    }

    public void clearUserProfile() {
        try {
            this.tokenManager.deleteUserProfile();
        }
        catch (TokenStoreException e) {
            throw new MssoException("Failed to remove User Profile: " + e.getMessage(), e);
        }
    }

    public void clearIdToken() {
        try {
            this.tokenManager.deleteIdToken();
        }
        catch (TokenStoreException e) {
            throw new MssoException("Failed to remove ID token: " + e.getMessage(), e);
        }
    }

    public IdToken getIdToken() {
        return this.isSsoEnabled() && this.tokenManager != null ? this.tokenManager.getIdToken() : null;
    }

    private void setIdToken(IdToken idToken) {
        if (this.isSsoEnabled()) {
            try {
                this.tokenManager.saveIdToken(idToken);
            }
            catch (TokenStoreException e) {
                throw new MssoException("Unable to store ID token: " + e.getMessage(), e);
            }
        }
    }

    public MASAuthCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(MASAuthCredentials credentials) {
        this.credentials = credentials;
    }

    public void clearCredentials() {
        MASAuthCredentials cred = this.getCredentials();
        if (cred != null) {
            cred.clear();
        }
        this.credentials = null;
    }

    public boolean isDeviceRegistered() {
        try {
            return this.tokenManager != null && this.tokenManager.isClientCertificateChainAvailable() && this.tokenManager.getMagIdentifier() != null;
        }
        catch (DataSourceException e) {
            if (MAS.DEBUG) {
                Log.w((String)"MAS", (String)("Device not registered: " + e));
            }
            return false;
        }
    }

    public void resetHttpClient() {
        MASConfiguration.SECURITY_CONFIGURATION_RESET.notifyObservers();
    }

    public MAGHttpClient getMAGHttpClient() {
        if (this.magHttpClient == null) {
            this.magHttpClient = new MAGHttpClient();
        }
        return this.magHttpClient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onIdTokenAvailable(IdToken idToken) throws JWTValidationException {
        this.clearCredentials();
        String deviceIdentifier = this.tokenManager.getMagIdentifier();
        String clientId = this.getClientId();
        String clientSecret = this.getClientSecret();
        if (idToken.getType().equals("urn:ietf:params:oauth:grant-type:jwt-bearer")) {
            if (!JWTValidation.validateIdToken(idToken, deviceIdentifier, clientId, clientSecret)) throw new JWTValidationException(13101, "JWT Token is not valid");
            this.setIdToken(idToken);
            return;
        } else {
            this.setIdToken(idToken);
        }
    }

    public void onDeviceRegistrationCompleted() {
        this.resetHttpClient();
    }

    public void onAccessTokenAvailable(String accessToken, String refreshToken, long expiresInSec, String grantedScope) {
        if (accessToken != null) {
            this.clearCredentials();
        }
        this.privateTokens.saveAccessToken(accessToken, refreshToken, expiresInSec, grantedScope);
    }

    public void clearAccessToken() {
        this.privateTokens.clear();
    }

    public String getAccessToken() {
        return this.privateTokens.getAccessToken();
    }

    public long getAccessTokenExpiry() {
        return this.privateTokens.getExpiry();
    }

    public String getGrantedScope() {
        return this.privateTokens.getGrantedScope();
    }

    public String takeRefreshToken() {
        return this.privateTokens.takeRefreshToken();
    }

    public String getRefreshToken() {
        return this.privateTokens.getRefreshToken();
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public MASResponse executeRequest(Bundle extra, MASRequest request) throws Exception {
        RequestInfo requestInfo = new RequestInfo(this, request, extra);
        final MAGInternalRequest internalRequest = requestInfo.getRequest();
        RetryRequestException lastError = null;
        while (requestInfo.getNumAttempts() < 4) {
            try {
                if (request.isPublic()) {
                    return this.getMAGHttpClient().execute(internalRequest);
                }
                return this.policyManager.execute(requestInfo, new PolicyManager.Route<MASResponse>(){

                    @Override
                    public MASResponse invoke() throws IOException {
                        if (internalRequest.isLocalRequest()) {
                            return ((LocalRequest)internalRequest.getRequest()).send(MssoContext.this);
                        }
                        return MssoContext.this.getMAGHttpClient().execute(internalRequest);
                    }
                });
            }
            catch (MAGServerException e) {
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)String.format("Server returned x-ca-err %d", e.getErrorCode()));
                }
                try {
                    this.rethrow(e);
                }
                catch (RetryRequestException rre) {
                    lastError = rre;
                    rre.recover(this);
                    if (MAS.DEBUG) {
                        Log.d((String)"MAS", (String)("Attempting to retry request. " + e.getClass()));
                    }
                }
            }
            catch (RetryRequestException e) {
                lastError = e;
                e.recover(this);
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)("Attempting to retry request. " + e.getClass()));
                }
            }
            catch (Exception e) {
                this.clearCredentials();
                throw e;
            }
            requestInfo.incrementNumAttempts();
        }
        this.clearCredentials();
        if (lastError != null) {
            throw lastError;
        }
        throw new IOException("Too many attempts, giving up");
    }

    private void rethrow(MAGServerException e) throws RetryRequestException, MAGServerException {
        int errorCode;
        String s;
        if (this.getCredentials() != null && !this.getCredentials().isReusable()) {
            this.clearCredentials();
        }
        if ((s = Integer.toString(errorCode = e.getErrorCode())).endsWith("201")) {
            throw new InvalidClientCredentialException(e);
        }
        if (s.endsWith("202")) {
            this.clearCredentials();
            throw new AuthenticationException(e);
        }
        if (s.endsWith("206")) {
            throw new CertificateExpiredException(e);
        }
        this.clearCredentials();
        throw e;
    }

    public void removeDeviceRegistration() {
        EventDispatcher.BEFORE_DEREGISTER.notifyObservers();
        if (this.tokenManager == null) {
            throw new IllegalStateException(MSSO_CONTEXT_NOT_INITIALIZED);
        }
        try {
            if (this.isDeviceRegistered()) {
                new RegistrationClient(this).removeDeviceRegistration();
            }
            EventDispatcher.AFTER_DEREGISTER.notifyObservers();
            this.resetHttpClient();
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.w((String)"MAS", (String)("Error in removing device registration details from the server " + e));
            }
            throw new MssoException(e);
        }
    }

    public void destroyAllPersistentTokens() {
        if (this.tokenManager == null) {
            throw new IllegalStateException(MSSO_CONTEXT_NOT_INITIALIZED);
        }
        this.clearCredentials();
        try {
            this.privateTokens.clearAll();
            this.clientCredentialTokens.clearAll();
            this.tokenManager.clearAll();
        }
        catch (DataSourceException | TokenStoreException e) {
            throw new MssoException(e);
        }
        finally {
            this.resetHttpClient();
        }
    }

    public void destroyPersistentTokens() {
        if (this.tokenManager == null) {
            throw new IllegalStateException(MSSO_CONTEXT_NOT_INITIALIZED);
        }
        try {
            this.privateTokens.clear();
            this.clientCredentialTokens.clear();
            this.tokenManager.clear();
        }
        catch (DataSourceException | TokenStoreException e) {
            throw new MssoException(e);
        }
        finally {
            this.resetHttpClient();
        }
    }

    public boolean isLogin() {
        return this.getIdToken() != null || this.getRefreshToken() != null;
    }

    public void setClientCredentials(ClientCredentials clientCredentials) {
        this.clientCredentialTokens.saveClientCredentials(clientCredentials);
    }

    public String getStoredClientId() {
        return this.clientCredentialTokens.getClientId();
    }

    public String getClientId() {
        String clientId = this.clientCredentialTokens.getClientId();
        if (clientId == null) {
            return this.configurationProvider.getClientId();
        }
        return clientId;
    }

    public String getClientSecret() {
        String clientSecret = this.clientCredentialTokens.getClientSecret();
        if (clientSecret == null) {
            clientSecret = this.configurationProvider.getClientSecret();
        }
        return clientSecret;
    }

    public Long getClientExpiration() {
        return this.clientCredentialTokens.getClientExpiration();
    }

    public void clearClientCredentials() {
        this.clientCredentialTokens.clear();
    }

    public boolean isClientCredentialExpired(Long clientExpiration) {
        return clientExpiration != 0L && clientExpiration < new Date().getTime() / 1000L;
    }
}

