/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.identity.common;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.identity.common.FilterFormatter;
import com.ca.mas.identity.common.MASFilteredRequestBuilder;
import com.ca.mas.identity.common.MASPagination;
import com.ca.mas.identity.util.IdentityUtil;
import java.util.ArrayList;
import java.util.List;

public class MASFilteredRequest
implements MASFilteredRequestBuilder,
MASPagination {
    private int mStartIndex;
    private int mCount;
    boolean mIsPaging;
    String mSortUri;
    String mQueryCondition;
    List<String> mQueryComponents;
    private Uri uri;
    protected List<String> mAttributes;
    protected List<String> mExcludedAttributes;
    private List<String> mEntityAttributes;
    private String mFilterType;

    public MASFilteredRequest(List<String> entityAttributes, String filterType) {
        this.mEntityAttributes = entityAttributes;
        this.mFilterType = filterType;
        this.mStartIndex = 1;
        this.mCount = 0;
        this.mIsPaging = false;
    }

    @Override
    public MASFilteredRequestBuilder setAttributes(List<String> attributes) {
        if (this.mExcludedAttributes != null) {
            throw new IllegalArgumentException("attributes and excludedAttributes are mutually exclusive.");
        }
        this.mAttributes = attributes;
        return this;
    }

    @Override
    public MASFilteredRequestBuilder setExcludedAttributes(List<String> excludedAttributes) {
        if (this.mAttributes != null) {
            throw new IllegalArgumentException("attributes and excludedAttributes are mutually exclusive.");
        }
        this.mExcludedAttributes = excludedAttributes;
        return this;
    }

    @Override
    public MASFilteredRequestBuilder setPagination(int start, int count) {
        this.mStartIndex = start;
        this.mCount = count;
        if (this.mCount > 0) {
            this.mIsPaging = true;
        }
        return this;
    }

    @Override
    public MASFilteredRequestBuilder setSortOrder(MASFilteredRequestBuilder.SortOrder sortOrder, @NonNull String attribute) {
        if (sortOrder == null) {
            sortOrder = MASFilteredRequestBuilder.SortOrder.ascending;
        }
        this.mSortUri = this.sortByUri(attribute, sortOrder);
        return this;
    }

    @Override
    public MASFilteredRequestBuilder isEqualTo(@NonNull String attribute, @NonNull String filterValue) {
        this.mQueryCondition = this.create(MASFilteredRequestBuilder.Operator.eq, attribute, filterValue);
        return this;
    }

    @Override
    public MASFilteredRequestBuilder isNotEqualTo(@NonNull String attribute, @NonNull String filterValue) {
        this.mQueryCondition = this.create(MASFilteredRequestBuilder.Operator.ne, attribute, filterValue);
        return this;
    }

    @Override
    public MASFilteredRequestBuilder contains(@NonNull String attribute, @NonNull String filterValue) {
        this.mQueryCondition = this.create(MASFilteredRequestBuilder.Operator.co, attribute, filterValue);
        return this;
    }

    @Override
    public MASFilteredRequestBuilder startsWith(@NonNull String attribute, @NonNull String filterValue) {
        this.mQueryCondition = this.create(MASFilteredRequestBuilder.Operator.sw, attribute, filterValue);
        return this;
    }

    @Override
    public MASFilteredRequestBuilder endsWith(@NonNull String attribute, @NonNull String filterValue) {
        this.mQueryCondition = this.create(MASFilteredRequestBuilder.Operator.ew, attribute, filterValue);
        return this;
    }

    @Override
    public MASFilteredRequestBuilder isPresent(@NonNull String attribute) {
        this.mQueryCondition = this.create(MASFilteredRequestBuilder.Operator.pr, attribute, null);
        return this;
    }

    @Override
    public MASFilteredRequestBuilder isGreaterThan(@NonNull String attribute, @NonNull String filterValue) {
        this.mQueryCondition = this.create(MASFilteredRequestBuilder.Operator.gt, attribute, filterValue);
        return this;
    }

    @Override
    public MASFilteredRequestBuilder isGreaterThanOrEqual(@NonNull String attribute, @NonNull String filterValue) {
        this.mQueryCondition = this.create(MASFilteredRequestBuilder.Operator.ge, attribute, filterValue);
        return this;
    }

    @Override
    public MASFilteredRequestBuilder isLessThan(@NonNull String attribute, @NonNull String filterValue) {
        this.mQueryCondition = this.create(MASFilteredRequestBuilder.Operator.lt, attribute, filterValue);
        return this;
    }

    @Override
    public MASFilteredRequestBuilder isLessThanOrEqual(@NonNull String attribute, @NonNull String filterValue) {
        this.mQueryCondition = this.create(MASFilteredRequestBuilder.Operator.le, attribute, filterValue);
        return this;
    }

    @Override
    public MASFilteredRequestBuilder createCompoundExpression(@NonNull MASFilteredRequestBuilder.Logical logical, MASRequest lhs, MASRequest rhs) {
        FilterFormatter filterFormatter = new FilterFormatter(logical, lhs, rhs);
        this.mQueryCondition = filterFormatter.toString();
        return this;
    }

    @Override
    public Uri createUri(@NonNull Context context) {
        String pagFilter;
        if (this.uri != null) {
            return this.uri;
        }
        this.mQueryComponents = new ArrayList<String>();
        StringBuilder fullUrl = new StringBuilder();
        if (this.mFilterType.equals("userAttributesKey")) {
            fullUrl.append(IdentityUtil.getUserPath());
        }
        if (this.mFilterType.equals("groupAttributesKey")) {
            fullUrl.append(IdentityUtil.getGroupPath());
        }
        if (!TextUtils.isEmpty((CharSequence)this.mQueryCondition)) {
            this.mQueryComponents.add(this.mQueryCondition);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSortUri)) {
            this.mQueryComponents.add(this.mSortUri);
        }
        if (this.mAttributes != null) {
            this.mQueryComponents.add(this.createNormalizedAttributes(this.mAttributes, "attributes"));
        }
        if (this.mExcludedAttributes != null) {
            this.mQueryComponents.add(this.createNormalizedAttributes(this.mExcludedAttributes, "excludedAttributes"));
        }
        if (this.mIsPaging && (pagFilter = this.getPaginationFilter()) != null) {
            this.mQueryComponents.add(pagFilter);
        }
        if (this.mQueryComponents.size() > 0) {
            fullUrl.append('?');
        }
        for (int i = 0; i < this.mQueryComponents.size(); ++i) {
            fullUrl.append(this.mQueryComponents.get(i));
            if (i >= this.mQueryComponents.size() - 1) continue;
            fullUrl.append('&');
        }
        String encUrl = fullUrl.toString().replaceAll(" ", "%20");
        encUrl = encUrl.replaceAll("\"", "%22");
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)("Encoded URL: " + encUrl));
        }
        this.uri = Uri.parse((String)encUrl);
        return this.uri;
    }

    private String createNormalizedAttributes(List<String> attrs, String key) {
        List<String> normalizedAttributes = IdentityUtil.normalizeAttributes(attrs, this.mEntityAttributes);
        StringBuilder sb = new StringBuilder();
        sb.append(key);
        sb.append("=");
        for (int i = 0; i < normalizedAttributes.size(); ++i) {
            sb.append(normalizedAttributes.get(i));
            if (i >= normalizedAttributes.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String getPaginationFilter() {
        String start = String.format("startIndex=%s", this.mStartIndex);
        String incBy = String.format("&count=%s", this.mCount);
        String pagFilter = start + incBy;
        this.mStartIndex += this.mCount;
        return pagFilter;
    }

    private String create(MASFilteredRequestBuilder.Operator op, String attribute, String filterValue) {
        FilterFormatter filterFormatter = new FilterFormatter(op, attribute, filterValue);
        return filterFormatter.toString();
    }

    private String sortByUri(String attribute, MASFilteredRequestBuilder.SortOrder sortOrder) {
        StringBuilder sb = new StringBuilder();
        String sortBy = String.format("sortBy=%s", attribute);
        sb.append(sortBy);
        sb.append('&');
        String so = String.format("sortOrder=%s", sortOrder.toString());
        sb.append(so);
        return sb.toString();
    }
}

