/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation.auth;

import android.content.AsyncTaskLoader;
import android.os.Parcel;
import android.os.Parcelable;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.service.AuthenticationProvider;
import com.ca.mas.core.service.Provider;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASUser;
import com.ca.mas.foundation.auth.MASAuthenticationProvider;
import com.ca.mas.foundation.notify.Callback;
import java.util.ArrayList;
import java.util.List;

public class MASAuthenticationProviders
implements Parcelable {
    private List<MASAuthenticationProvider> providers;
    private String idp;
    public static final Parcelable.Creator<MASAuthenticationProviders> CREATOR = new Parcelable.Creator<MASAuthenticationProviders>(){

        public MASAuthenticationProviders createFromParcel(Parcel source) {
            return new MASAuthenticationProviders(source);
        }

        public MASAuthenticationProviders[] newArray(int size) {
            return new MASAuthenticationProviders[size];
        }
    };

    public MASAuthenticationProviders(AuthenticationProvider provider) {
        List<Provider> ps;
        this.providers = new ArrayList<MASAuthenticationProvider>();
        if (provider != null && (ps = provider.getProviders()) != null && !ps.isEmpty()) {
            for (Provider p : ps) {
                this.providers.add(new MASAuthenticationProvider(p));
            }
        }
        this.idp = provider == null ? null : provider.getIdp();
    }

    public static void getAuthenticationProviders(final MASCallback<MASAuthenticationProviders> callback) {
        if (MASUser.getCurrentUser() == null || !MASUser.getCurrentUser().isAuthenticated()) {
            new AsyncTaskLoader<Object>(MAS.getContext()){

                protected void onStartLoading() {
                    super.onStartLoading();
                    this.forceLoad();
                }

                public Object loadInBackground() {
                    try {
                        AuthenticationProvider ap = MobileSsoFactory.getInstance().getAuthenticationProvider();
                        Callback.onSuccess(callback, new MASAuthenticationProviders(ap));
                    }
                    catch (Exception e) {
                        Callback.onError(callback, e);
                    }
                    return null;
                }
            }.startLoading();
        } else {
            Callback.onSuccess(callback, null);
        }
    }

    public List<MASAuthenticationProvider> getProviders() {
        return this.providers;
    }

    public String getIdp() {
        return this.idp;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.providers);
        dest.writeString(this.idp);
    }

    protected MASAuthenticationProviders(Parcel in) {
        this.providers = in.createTypedArrayList(MASAuthenticationProvider.CREATOR);
        this.idp = in.readString();
    }
}

