/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation.auth;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.Pair;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.service.Provider;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASResponseBody;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;

public class MASAuthenticationProvider
implements Parcelable {
    private Provider provider;
    public static final Parcelable.Creator<MASAuthenticationProvider> CREATOR = new Parcelable.Creator<MASAuthenticationProvider>(){

        public MASAuthenticationProvider createFromParcel(Parcel source) {
            return new MASAuthenticationProvider(source);
        }

        public MASAuthenticationProvider[] newArray(int size) {
            return new MASAuthenticationProvider[size];
        }
    };

    protected MASAuthenticationProvider(Provider provider) {
        this.provider = provider;
    }

    public String getIdentifier() {
        return this.provider.getId();
    }

    public String getAuthenticationUrl() {
        return this.provider.getUrl();
    }

    public String getPollUrl() {
        return this.provider.getPollUrl();
    }

    public boolean isEnterprise() {
        return this.provider.getId().equalsIgnoreCase("enterprise");
    }

    public boolean isFacebook() {
        return this.provider.getId().equalsIgnoreCase("facebook");
    }

    public boolean isGoogle() {
        return this.provider.getId().equalsIgnoreCase("google");
    }

    public boolean isLinkedIn() {
        return this.provider.getId().equalsIgnoreCase("linkedin");
    }

    public boolean isSalesForce() {
        return this.provider.getId().equalsIgnoreCase("salesforce");
    }

    public boolean isProximityLogin() {
        return this.provider.getId().equalsIgnoreCase("qrcode");
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.provider, flags);
    }

    protected MASAuthenticationProvider(Parcel in) {
        this.provider = (Provider)in.readParcelable(Provider.class.getClassLoader());
    }

    public void getAuthConfiguration(Context context, MASAuthenticationProvider provider, MASCallback<Uri> callback) {
        MASRequest request = new MASRequest.MASRequestBuilder(Uri.parse((String)provider.getAuthenticationUrl())).get().responseBody(MASResponseBody.jsonBody()).build();
        MagTask magTask = new MagTask(context, request, callback);
        magTask.execute(new Void[0]);
    }

    private static class MagTask
    extends AsyncTask<Void, Void, Pair<MASResponse<Object>, Exception>> {
        Context context;
        MASRequest request;
        MASCallback<Uri> callback;

        MagTask(Context context, MASRequest request, MASCallback<Uri> callback) {
            this.context = context;
            this.request = request;
            this.callback = callback;
        }

        protected Pair<MASResponse<Object>, Exception> doInBackground(Void ... params) {
            MAGHttpClient magHttpClient = new MAGHttpClient(){

                @Override
                protected void onConnectionObtained(HttpURLConnection connection) {
                    connection.setInstanceFollowRedirects(false);
                }
            };
            try {
                return new Pair(magHttpClient.execute(this.request), null);
            }
            catch (Exception e) {
                Log.d((String)"", (String)e.getMessage());
                return new Pair(null, (Object)e);
            }
        }

        protected void onPostExecute(Pair<MASResponse<Object>, Exception> magResponse) {
            super.onPostExecute(magResponse);
            if (magResponse != null) {
                MASResponse response = (MASResponse)magResponse.first;
                Exception ex = (Exception)magResponse.second;
                if (response != null) {
                    Map<String, List<String>> headers = response.getHeaders();
                    String location = headers.get("Location").get(0);
                    this.callback.onSuccess(Uri.parse((String)location));
                } else if (ex != null) {
                    this.callback.onError(ex);
                }
            }
        }
    }
}

