/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.util;

import android.annotation.TargetApi;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyProtection;
import android.security.keystore.UserNotAuthenticatedException;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.ca.mas.foundation.MAS;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public class KeyUtilsSymmetric {
    private static final String DEFAULT_ALGORITHM = "AES";
    private static final int DEFAULT_KEY_LENGTH = 256;
    private static final String ANDROID_KEY_STORE = "AndroidKeyStore";
    private static final String AES_GCM_NO_PADDING = "AES/GCM/NoPadding";
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final int IV_LENGTH = 12;

    public static SecretKey generateKey(String alias, String algorithm, int keyLength, boolean inMemory, boolean userAuthenticationRequired, int userAuthenticationValiditySeconds, boolean invalidatedByBiometricEnrollment) {
        SecretKey returnKey = null;
        if (algorithm == null || algorithm.trim().length() == 0) {
            if (MAS.DEBUG) {
                Log.d((String)"MAS", (String)("Algorithm (" + algorithm + ") is either null or zero length, assigning default: " + DEFAULT_ALGORITHM));
            }
            algorithm = DEFAULT_ALGORITHM;
        }
        if (keyLength < 256) {
            if (MAS.DEBUG) {
                Log.d((String)"MAS", (String)("key length (" + keyLength + ") is less than zero, assigning default: " + 256));
            }
            keyLength = 256;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            if (inMemory) {
                returnKey = KeyUtilsSymmetric.generateKeyInMemory(algorithm, keyLength);
                if (Build.VERSION.SDK_INT >= 24) {
                    KeyUtilsSymmetric.storeKeyAndroidN(alias, returnKey, userAuthenticationRequired, userAuthenticationValiditySeconds, invalidatedByBiometricEnrollment);
                } else {
                    KeyUtilsSymmetric.storeKeyAndroidM(alias, returnKey, userAuthenticationRequired, userAuthenticationValiditySeconds);
                }
            } else {
                returnKey = Build.VERSION.SDK_INT >= 24 ? KeyUtilsSymmetric.generateKeyInAndroidKeyStoreAndroidN(alias, algorithm, keyLength, userAuthenticationRequired, userAuthenticationValiditySeconds, invalidatedByBiometricEnrollment) : KeyUtilsSymmetric.generateKeyInAndroidKeyStoreAndroidM(alias, algorithm, keyLength, userAuthenticationRequired, userAuthenticationValiditySeconds);
            }
        } else {
            returnKey = KeyUtilsSymmetric.generateKeyInMemory(algorithm, keyLength);
        }
        return returnKey;
    }

    private static SecretKey generateKeyInMemory(String algorithm, int keyLength) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(algorithm);
            kg.init(keyLength);
            return kg.generateKey();
        }
        catch (Exception x) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error generateKeyInMemory", (Throwable)x);
            }
            throw new RuntimeException("Error generateKeyInMemory", x);
        }
    }

    @TargetApi(value=23)
    private static SecretKey generateKeyInAndroidKeyStoreAndroidM(String alias, String algorithm, int keyLength, boolean userAuthenticationRequired, int userAuthenticationValiditySeconds) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm, ANDROID_KEY_STORE);
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(alias, 3).setKeySize(keyLength < 256 ? 256 : keyLength).setBlockModes(new String[]{"CBC", "CTR", "GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setRandomizedEncryptionRequired(true).setUserAuthenticationRequired(userAuthenticationRequired);
            if (userAuthenticationRequired && userAuthenticationValiditySeconds > 0) {
                builder.setUserAuthenticationValidityDurationSeconds(userAuthenticationValiditySeconds);
            }
            KeyGenParameterSpec keyGenSpec = builder.build();
            keyGenerator.init((AlgorithmParameterSpec)keyGenSpec);
            return keyGenerator.generateKey();
        }
        catch (Exception x) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error generateKeyInAndroidKeyStore", (Throwable)x);
            }
            throw new RuntimeException("Error generateKeyInAndroidKeyStore", x);
        }
    }

    @TargetApi(value=24)
    private static SecretKey generateKeyInAndroidKeyStoreAndroidN(String alias, String algorithm, int keyLength, boolean userAuthenticationRequired, int userAuthenticationValiditySeconds, boolean invalidatedByBiometricEnrollment) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm, ANDROID_KEY_STORE);
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(alias, 3).setKeySize(keyLength < 256 ? 256 : keyLength).setBlockModes(new String[]{"CBC", "CTR", "GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setRandomizedEncryptionRequired(true).setUserAuthenticationRequired(userAuthenticationRequired).setInvalidatedByBiometricEnrollment(invalidatedByBiometricEnrollment);
            if (userAuthenticationRequired && userAuthenticationValiditySeconds > 0) {
                builder.setUserAuthenticationValidityDurationSeconds(userAuthenticationValiditySeconds);
            }
            KeyGenParameterSpec keyGenSpec = builder.build();
            keyGenerator.init((AlgorithmParameterSpec)keyGenSpec);
            SecretKey key = keyGenerator.generateKey();
            return key;
        }
        catch (Exception x) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error generateKeyInAndroidKeyStore", (Throwable)x);
            }
            throw new RuntimeException("Error generateKeyInAndroidKeyStore", x);
        }
    }

    public static SecretKey retrieveKey(String alias) {
        if (Build.VERSION.SDK_INT >= 23) {
            return KeyUtilsSymmetric.retrieveKeyAndroidM(alias);
        }
        return null;
    }

    @TargetApi(value=23)
    private static SecretKey retrieveKeyAndroidM(String alias) {
        SecretKey sk;
        KeyStore ks;
        try {
            ks = KeyStore.getInstance(ANDROID_KEY_STORE);
        }
        catch (KeyStoreException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error while instantiating Android KeyStore instance", (Throwable)e);
            }
            throw new RuntimeException("Error while instantiating Android KeyStore instance", e);
        }
        try {
            ks.load(null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error while loading Android KeyStore instance", (Throwable)e);
            }
            throw new RuntimeException("Error while loading Android KeyStore instance", e);
        }
        try {
            KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)ks.getEntry(alias, null);
            if (entry == null) {
                return null;
            }
            sk = entry.getSecretKey();
        }
        catch (NullPointerException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error while getting entry from Android KeyStore", (Throwable)e);
            }
            throw new RuntimeException("Error while getting entry from Android KeyStore", e);
        }
        return sk;
    }

    @TargetApi(value=23)
    public static boolean storeKeyAndroidM(String alias, SecretKey secretKey, boolean userAuthenticationRequired, int userAuthenticationValiditySeconds) {
        KeyStore ks;
        try {
            ks = KeyStore.getInstance(ANDROID_KEY_STORE);
            ks.load(null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error instantiating Android keyStore");
            }
            throw new RuntimeException("Error instantiating Android keyStore", e);
        }
        KeyProtection.Builder builder = new KeyProtection.Builder(3).setBlockModes(new String[]{"CBC", "CTR", "GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setRandomizedEncryptionRequired(true).setUserAuthenticationRequired(userAuthenticationRequired);
        if (userAuthenticationRequired && userAuthenticationValiditySeconds > 0) {
            builder.setUserAuthenticationValidityDurationSeconds(userAuthenticationValiditySeconds);
        }
        KeyProtection kp = builder.build();
        try {
            ks.setEntry(alias, new KeyStore.SecretKeyEntry(secretKey), (KeyStore.ProtectionParameter)kp);
            return true;
        }
        catch (KeyStoreException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error setting entry into Android keyStore");
            }
            throw new RuntimeException("Error setting entry into Android keyStore", e);
        }
    }

    @RequiresApi(value=24)
    public static boolean storeKeyAndroidN(String alias, SecretKey secretKey, boolean userAuthenticationRequired, int userAuthenticationValiditySeconds, boolean invalidatedByBiometricEnrollment) {
        KeyStore ks;
        try {
            ks = KeyStore.getInstance(ANDROID_KEY_STORE);
            ks.load(null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error instantiating Android keyStore");
            }
            throw new RuntimeException("Error instantiating Android keyStore", e);
        }
        KeyProtection.Builder builder = new KeyProtection.Builder(3).setBlockModes(new String[]{"CBC", "CTR", "GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setRandomizedEncryptionRequired(true).setUserAuthenticationRequired(userAuthenticationRequired).setInvalidatedByBiometricEnrollment(invalidatedByBiometricEnrollment);
        if (userAuthenticationRequired && userAuthenticationValiditySeconds > 0) {
            builder.setUserAuthenticationValidityDurationSeconds(userAuthenticationValiditySeconds);
        }
        KeyProtection kp = builder.build();
        try {
            ks.setEntry(alias, new KeyStore.SecretKeyEntry(secretKey), (KeyStore.ProtectionParameter)kp);
            return true;
        }
        catch (KeyStoreException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error setting entry into Android keyStore");
            }
            throw new RuntimeException("Error setting entry into Android keyStore", e);
        }
    }

    public static void deleteKey(String alias) {
        if (Build.VERSION.SDK_INT >= 23) {
            KeyUtilsSymmetric.deleteKeyAndroidM(alias);
        }
    }

    @RequiresApi(value=23)
    private static void deleteKeyAndroidM(String alias) {
        KeyStore ks;
        try {
            ks = KeyStore.getInstance(ANDROID_KEY_STORE);
        }
        catch (KeyStoreException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error instantiating Android keyStore");
            }
            throw new RuntimeException("Error instantiating Android keyStore", e);
        }
        try {
            ks.load(null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error loading Android keyStore");
            }
            throw new RuntimeException("Error loading Android keyStore", e);
        }
        try {
            ks.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error deleting Android keyStore");
            }
            throw new RuntimeException("Error deleting Android keyStore", e);
        }
    }

    public static byte[] encrypt(byte[] data, SecretKey secretKey, String key) {
        byte[] encryptedData;
        if (data == null) {
            return null;
        }
        try {
            byte[] iv;
            Cipher cipher = Cipher.getInstance(AES_GCM_NO_PADDING);
            if (Build.VERSION.SDK_INT >= 23) {
                cipher.init(1, secretKey);
                iv = cipher.getIV();
            } else {
                iv = new byte[12];
                SecureRandom secureRandom = new SecureRandom();
                secureRandom.nextBytes(iv);
                AlgorithmParameterSpec ivParams = Build.VERSION.SDK_INT >= 21 ? new GCMParameterSpec(128, iv) : new IvParameterSpec(iv);
                cipher.init(1, (Key)secretKey, ivParams);
            }
            encryptedData = cipher.doFinal(data);
            byte[] mac = KeyUtilsSymmetric.computeMac(key, encryptedData);
            encryptedData = KeyUtilsSymmetric.concatArrays(mac, iv, encryptedData);
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"inside exception of encrypt function: ", (Throwable)e);
            }
            if (Build.VERSION.SDK_INT >= 23) {
                KeyUtilsSymmetric.checkDeleteKeys(key, e);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        return encryptedData;
    }

    public static byte[] decrypt(byte[] encryptedData, SecretKey secretKey, String key) {
        int macLength;
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(AES_GCM_NO_PADDING);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error while getting an cipher instance", (Throwable)e);
            }
            throw new RuntimeException("Error while getting an cipher instance", e);
        }
        int ivlength = 12;
        try {
            macLength = Mac.getInstance(HMAC_SHA256).getMacLength();
        }
        catch (NoSuchAlgorithmException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error while instantiating MAC", (Throwable)e);
            }
            throw new RuntimeException("Error while instantiating MAC", e);
        }
        int encryptedDataLength = encryptedData.length - ivlength - macLength;
        byte[] macFromMessage = KeyUtilsSymmetric.getArraySubset(encryptedData, 0, macLength);
        byte[] iv = KeyUtilsSymmetric.getArraySubset(encryptedData, macLength, ivlength);
        encryptedData = KeyUtilsSymmetric.getArraySubset(encryptedData, macLength + ivlength, encryptedDataLength);
        byte[] mac = KeyUtilsSymmetric.computeMac(key, encryptedData);
        if (!Arrays.equals(mac, macFromMessage)) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"MAC signature could not be verified");
            }
            throw new RuntimeException("MAC signature could not be verified");
        }
        AlgorithmParameterSpec ivParams = Build.VERSION.SDK_INT >= 21 ? new GCMParameterSpec(128, iv) : new IvParameterSpec(iv);
        try {
            cipher.init(2, (Key)secretKey, ivParams);
            return cipher.doFinal(encryptedData);
        }
        catch (Exception e) {
            if (Build.VERSION.SDK_INT >= 23) {
                KeyUtilsSymmetric.checkDeleteKeys(key, e);
            }
            if (MAS.DEBUG) {
                Log.i((String)"MAS", (String)"Error while decrypting an cipher instance", (Throwable)e);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static byte[] computeMac(String key, byte[] cipherText) {
        byte[] byArray;
        SecretKeySpec secretKey = null;
        try {
            Mac hm = Mac.getInstance(HMAC_SHA256);
            secretKey = new SecretKeySpec(key.getBytes("UTF-8"), HMAC_SHA256);
            hm.init(secretKey);
            byArray = hm.doFinal(cipherText);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            try {
                if (MAS.DEBUG) {
                    Log.e((String)"MAS", (String)"Error while calculating signature", (Throwable)e);
                }
                throw new RuntimeException("Error while calculating signature", e);
            }
            catch (Throwable throwable) {
                KeyUtilsSymmetric.destroyKey(secretKey);
                throw throwable;
            }
        }
        KeyUtilsSymmetric.destroyKey(secretKey);
        return byArray;
    }

    private static byte[] concatArrays(byte[] mac, byte[] iv, byte[] cipherText) {
        int macLength = mac.length;
        int ivLength = iv.length;
        int cipherTextLength = cipherText.length;
        int totalLength = macLength + ivLength + cipherTextLength;
        byte[] result = new byte[totalLength];
        System.arraycopy(mac, 0, result, 0, macLength);
        System.arraycopy(iv, 0, result, macLength, ivLength);
        System.arraycopy(cipherText, 0, result, macLength + ivLength, cipherTextLength);
        return result;
    }

    private static byte[] getArraySubset(byte[] array, int start, int length) {
        byte[] result = new byte[length];
        System.arraycopy(array, start, result, 0, length);
        return result;
    }

    private static void destroyKey(SecretKey key) {
        block3: {
            if (key instanceof Destroyable) {
                try {
                    key.destroy();
                }
                catch (DestroyFailedException e) {
                    if (!MAS.DEBUG) break block3;
                    Log.e((String)"MAS", (String)"Could not destroy key");
                }
            }
        }
    }

    @RequiresApi(value=23)
    private static void checkDeleteKeys(String alias, Exception e) {
        if (!(e instanceof UserNotAuthenticatedException)) {
            KeyUtilsSymmetric.deleteKey(alias);
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("deleted key " + alias + " since User not authenticated"));
            }
        }
    }

    protected KeyUtilsSymmetric() {
    }
}

