/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.token;

import android.util.Base64;
import com.ca.mas.core.token.JWTInvalidSignatureException;
import com.ca.mas.core.token.JWTValidationException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class JWTHmac {
    private JWTHmac() {
        throw new IllegalAccessError("Utility class");
    }

    static boolean validateHMacSignature(byte[] header, byte[] payload, byte[] clientSecret, byte[] signature) throws JWTValidationException {
        byte[] decodedSignature;
        byte[] signToCompare = JWTHmac.signData(header, payload, clientSecret);
        if (!new String(signToCompare).equals(new String(decodedSignature = Base64.decode((byte[])signature, (int)8)))) {
            throw new JWTInvalidSignatureException("Token Validation Failed: The signatures do not match");
        }
        return true;
    }

    private static byte[] signData(byte[] header, byte[] payload, byte[] secret) throws JWTValidationException {
        try {
            if (secret == null || secret.length == 0) {
                return null;
            }
            Mac mac = Mac.getInstance("HMACSHA256");
            mac.init(new SecretKeySpec(secret, "HMACSHA256"));
            byte[] jwsSecuredInput = JWTHmac.createSecuredInput(header, payload);
            byte[] signature = mac.doFinal(jwsSecuredInput);
            return signature;
        }
        catch (Exception e) {
            throw new JWTInvalidSignatureException("Sign Data failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] createSecuredInput(byte[] header, byte[] payload) {
        byte[] separator = ".".getBytes();
        byte[] jwsSecuredInput = new byte[header.length + separator.length + payload.length];
        System.arraycopy(header, 0, jwsSecuredInput, 0, header.length);
        System.arraycopy(separator, 0, jwsSecuredInput, header.length, separator.length);
        System.arraycopy(payload, 0, jwsSecuredInput, header.length + separator.length, payload.length);
        return jwsSecuredInput;
    }
}

