/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.util.Base64;
import com.ca.mas.core.security.KeyStoreKeyStorageProvider;

class SharedPreferencesKeyStorageProvider
extends KeyStoreKeyStorageProvider {
    public static final String PREFS_NAME = "SECRET_PREFS";
    private SharedPreferences sharedpreferences;

    public SharedPreferencesKeyStorageProvider(@NonNull Context ctx) {
        super(ctx);
    }

    @Override
    protected boolean storeSecretKeyLocally(String alias, byte[] encryptedSecretkey) {
        this.sharedpreferences = this.getContext().getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = this.sharedpreferences.edit();
        String stringToSave = Base64.encodeToString((byte[])encryptedSecretkey, (int)0);
        editor.putString(alias, stringToSave);
        editor.apply();
        return true;
    }

    protected boolean containsSecretKeyLocally(String alias) {
        this.sharedpreferences = this.getContext().getSharedPreferences(PREFS_NAME, 0);
        return this.sharedpreferences.contains(alias);
    }

    @Override
    protected boolean deleteSecretKeyLocally(String alias) {
        this.sharedpreferences = this.getContext().getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = this.sharedpreferences.edit();
        editor.remove(alias);
        editor.apply();
        return true;
    }

    @Override
    protected byte[] getEncryptedSecretKey(String alias) {
        this.sharedpreferences = this.getContext().getSharedPreferences(PREFS_NAME, 0);
        String sretrieve = this.sharedpreferences.getString(alias, "default");
        byte[] encryptedSecretKey = Base64.decode((String)sretrieve, (int)0);
        return encryptedSecretKey;
    }
}

