/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import com.ca.mas.core.cert.CertUtils;
import com.ca.mas.core.security.GenerateKeyAttribute;
import com.ca.mas.core.security.KeyStore;
import com.ca.mas.core.security.KeyStoreAdapter;
import com.ca.mas.core.security.KeyStoreException;
import com.ca.mas.core.security.KeyStoreRepository;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AndroidJellyBeanKeyRepository
extends KeyStoreRepository {
    private static final String PUTBLIC_KEY = "_public_key";
    private KeyStore keyStore = KeyStoreAdapter.getKeyStore();

    @Override
    public Key getPrivateKey(String alias) throws KeyStoreException {
        byte[] privateKey = this.keyStore.get(alias);
        if (privateKey != null) {
            try {
                return this.decodeRsaPrivateKey(privateKey);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Key getPublicKey(String alias) throws KeyStoreException {
        byte[] publicKey = this.keyStore.get(alias + PUTBLIC_KEY);
        if (publicKey != null) {
            try {
                return this.decodeRsaPublicKey(publicKey);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void deleteKey(String alias) {
        this.keyStore.delete(alias);
        this.keyStore.delete(alias + PUTBLIC_KEY);
    }

    @Override
    public KeyPair createPrivateKey(String alias, GenerateKeyAttribute attributes) throws KeyStoreException {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", (Provider)new BouncyCastleProvider());
            kpg.initialize(attributes.getKeySize());
            KeyPair keyPair = kpg.generateKeyPair();
            byte[] privateKey = AndroidJellyBeanKeyRepository.encodeRsaPrivateKey(keyPair.getPrivate());
            byte[] publicKey = this.encodeRsaPublicKey(keyPair.getPublic());
            this.keyStore.put(alias, privateKey);
            this.keyStore.put(alias + PUTBLIC_KEY, publicKey);
            return keyPair;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public void saveCertificateChain(String alias, X509Certificate[] chain) {
        byte[] certs = CertUtils.encodeCertificateChain(chain);
        this.keyStore.put(alias, certs);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        byte[] certs = this.keyStore.get(alias);
        return CertUtils.decodeCertificateChain(certs);
    }

    @Override
    public void deleteCertificateChain(String alias) {
        this.keyStore.delete(alias);
    }

    @Override
    public byte[] generateCertificateSigningRequest(String commonName, String deviceId, String deviceName, String organization, PrivateKey privateKey, PublicKey publicKey) throws CertificateException {
        try {
            X500Principal subject = new X500Principal("cn=" + commonName + ", ou=" + deviceId + ", dc=" + deviceName + ", o=" + organization);
            DERSet attrs = new DERSet(new ASN1EncodableVector());
            PKCS10CertificationRequest csr = new PKCS10CertificationRequest("SHA1withRSA", subject, publicKey, (ASN1Set)attrs, privateKey, null);
            return csr.getEncoded();
        }
        catch (Exception e) {
            throw new CertificateException("Unable to generate certificate signing request: " + e.getMessage(), e);
        }
    }

    private static byte[] encodeRsaPrivateKey(PrivateKey privateKey) {
        if (!"RSA".equals(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("Private key is not an RSA private key: " + privateKey.getAlgorithm());
        }
        if (!"PKCS#8".equals(privateKey.getFormat())) {
            throw new IllegalArgumentException("Private key encoding format is not PKCS#8: " + privateKey.getFormat());
        }
        byte[] bytes = privateKey.getEncoded();
        if (bytes == null || bytes.length < 1) {
            throw new IllegalArgumentException("Private key encoded form is null or empty");
        }
        return bytes;
    }

    private PrivateKey decodeRsaPrivateKey(byte[] pkcs8EncodedKeyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(pkcs8EncodedKeyBytes));
    }

    private byte[] encodeRsaPublicKey(PublicKey publicKey) {
        if (!"RSA".equals(publicKey.getAlgorithm())) {
            throw new IllegalArgumentException("Public key is not an RSA private key: " + publicKey.getAlgorithm());
        }
        String format = publicKey.getFormat();
        if (!"X.509".equals(format) && !"X509".equals(format)) {
            throw new IllegalArgumentException("Public key encoding format is not X.509: " + format);
        }
        byte[] bytes = publicKey.getEncoded();
        if (bytes == null || bytes.length < 1) {
            throw new IllegalArgumentException("Public key encoded form is null or empty");
        }
        return bytes;
    }

    private PublicKey decodeRsaPublicKey(byte[] x509EncodedKeyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(x509EncodedKeyBytes));
    }
}

