/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.core.auth.AuthenticationException;
import com.ca.mas.core.client.ServerClient;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.oauth.OAuthException;
import com.ca.mas.core.oauth.OAuthServerException;
import com.ca.mas.core.oauth.OAuthTokenClient;
import com.ca.mas.core.oauth.OAuthTokenResponse;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.exceptions.CredentialRequiredException;
import com.ca.mas.core.policy.exceptions.RetryRequestException;
import com.ca.mas.core.request.MAGInternalRequest;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.core.token.JWTValidationException;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASGrantProvider;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class AccessTokenAssertion
implements MssoAssertion {
    private static final String TOKEN_EXPIRED_ERROR_CODE_SUFFIX = "990";
    private static final int INVALID_CLIENT_CREDENTIALS = 3003201;
    private static final int INVALID_SCOPE = 3003115;
    private static final int INVALID_MAG_IDENTIFIER = 3003107;
    private static final int INVALID_CLIENT_CERTIFICATE = 3003206;
    private OAuthTokenClient oAuthTokenClient;

    AccessTokenAssertion() {
    }

    @Override
    public void init(@NonNull MssoContext mssoContext, @NonNull Context sysContext) {
        this.oAuthTokenClient = new OAuthTokenClient(mssoContext);
    }

    @Override
    public synchronized void processRequest(MssoContext mssoContext, RequestInfo request) throws MAGException, MAGServerException {
        if (request.getRequest().getURL() != null && request.getRequest().getURL().getHost() == null) {
            throw new IllegalArgumentException("Host is not provided");
        }
        MAGInternalRequest magInternalRequest = request.getRequest();
        String accessToken = this.findAccessToken(mssoContext, magInternalRequest);
        if (accessToken != null) {
            request.getRequest().addHeader("Authorization", "Bearer " + accessToken);
        }
    }

    @Override
    public void processResponse(MssoContext mssoContext, RequestInfo request, MASResponse response) throws MAGException {
        int errorCode = ServerClient.findErrorCode(response);
        if (errorCode == -1) {
            return;
        }
        String s = Integer.toString(errorCode);
        if (s.endsWith(TOKEN_EXPIRED_ERROR_CODE_SUFFIX)) {
            throw new RetryRequestException("Access token rejected by server"){

                @Override
                public void recover(MssoContext context) {
                    context.clearAccessToken();
                }
            };
        }
    }

    @Override
    public void close() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String findAccessToken(MssoContext mssoContext, MAGInternalRequest request) throws CredentialRequiredException, OAuthException, OAuthServerException, AuthenticationException, JWTValidationException, RetryRequestException {
        IdToken idToken;
        boolean ssoEnabled;
        String accessToken = mssoContext.getAccessToken();
        if (accessToken != null) {
            if (this.isAccessTokenStillValid(mssoContext)) {
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)"Access Token is still valid.");
                }
                if (this.isSufficientScope(mssoContext, request)) {
                    if (request.getGrantProvider() != MASGrantProvider.PASSWORD) return accessToken;
                    if (mssoContext.getRefreshToken() != null) return accessToken;
                    mssoContext.clearAccessToken();
                    accessToken = null;
                } else {
                    if (MAS.DEBUG) {
                        Log.d((String)"MAS", (String)"Access Token does not have sufficient scope.");
                    }
                    mssoContext.clearAccessToken();
                    accessToken = null;
                }
            } else {
                accessToken = null;
            }
            String refreshToken = mssoContext.getRefreshToken();
            if (refreshToken != null) {
                accessToken = this.obtainAccessTokenUsingRefreshToken(mssoContext, refreshToken);
            }
            if (accessToken != null) {
                return accessToken;
            }
        }
        if (!(ssoEnabled = ((Boolean)mssoContext.getConfigurationProvider().getProperty("msso.sso.enabled")).booleanValue()) || (idToken = mssoContext.getIdToken()) == null) return this.obtainAccessTokenUsingCredential(mssoContext, request, ssoEnabled);
        return this.obtainAccessTokenUsingIdToken(mssoContext, idToken, request);
    }

    private boolean isAccessTokenStillValid(MssoContext mssoContext) {
        long expiry;
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)"Validating access token expiration");
        }
        return (expiry = mssoContext.getAccessTokenExpiry()) <= 0L || System.currentTimeMillis() <= expiry;
    }

    private boolean isSufficientScope(MssoContext mssoContext, MASRequest request) {
        String rScope = request.getScope();
        String gScope = mssoContext.getGrantedScope();
        if (rScope == null || rScope.trim().length() == 0) {
            return true;
        }
        if (gScope == null || gScope.trim().length() == 0) {
            return false;
        }
        String[] requestScopes = rScope.trim().split("\\s+");
        ArrayList rScopeList = new ArrayList();
        Collections.addAll(rScopeList, requestScopes);
        rScopeList.remove("openid");
        rScopeList.remove("msso");
        rScopeList.remove("msso_register");
        rScopeList.remove("msso_client_register");
        String[] grantedScopes = gScope.split("\\s+");
        List<String> gScopeList = Arrays.asList(grantedScopes);
        return gScopeList.containsAll(rScopeList);
    }

    private static void checkCredentials(MssoContext mssoContext, MAGInternalRequest request) throws CredentialRequiredException {
        MASAuthCredentials creds = request.getGrantProvider().getCredentials(mssoContext);
        if (creds == null || !creds.isValid()) {
            throw new CredentialRequiredException();
        }
    }

    private String obtainAccessTokenUsingIdToken(MssoContext mssoContext, IdToken idToken, MAGInternalRequest request) throws CredentialRequiredException, OAuthException, JWTValidationException, OAuthServerException {
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)"Try to use id token to get new Access Token");
        }
        String clientId = mssoContext.getClientId();
        String clientSecret = mssoContext.getClientSecret();
        String scope = request.getScope();
        try {
            OAuthTokenResponse response = this.oAuthTokenClient.obtainAccessTokenUsingIdToken(idToken, clientId, clientSecret, scope);
            IdToken responseIdToken = response.getIdToken();
            if (responseIdToken != null) {
                mssoContext.onIdTokenAvailable(responseIdToken);
            }
            String accessToken = response.getAccessToken();
            mssoContext.onAccessTokenAvailable(accessToken, response.getRefreshToken(), response.getExpiresIn(), response.getGrantedScope());
            return accessToken;
        }
        catch (OAuthServerException e) {
            this.rethrowOrIgnore(e);
            mssoContext.clearIdToken();
            mssoContext.clearUserProfile();
            return this.obtainAccessTokenUsingCredential(mssoContext, request, true);
        }
    }

    private String obtainAccessTokenUsingCredential(MssoContext mssoContext, MAGInternalRequest request, boolean wantIdToken) throws CredentialRequiredException, OAuthServerException, OAuthException, JWTValidationException {
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)"Obtain access token using Credential");
        }
        mssoContext.clearUserProfile();
        AccessTokenAssertion.checkCredentials(mssoContext, request);
        String clientId = mssoContext.getClientId();
        String clientSecret = mssoContext.getClientSecret();
        OAuthTokenResponse response = this.oAuthTokenClient.obtainTokensUsingCredentials(request, clientId, clientSecret, wantIdToken);
        IdToken idToken = response.getIdToken();
        if (idToken != null) {
            mssoContext.onIdTokenAvailable(idToken);
        }
        String accessToken = response.getAccessToken();
        mssoContext.onAccessTokenAvailable(accessToken, response.getRefreshToken(), response.getExpiresIn(), response.getGrantedScope());
        return accessToken;
    }

    private String obtainAccessTokenUsingRefreshToken(MssoContext mssoContext, String refreshToken) throws OAuthException, OAuthServerException {
        String accessToken;
        block3: {
            if (MAS.DEBUG) {
                Log.d((String)"MAS", (String)"Obtain Access Token using Refresh Token");
            }
            String clientId = mssoContext.getClientId();
            String clientSecret = mssoContext.getClientSecret();
            accessToken = null;
            try {
                OAuthTokenResponse response = this.oAuthTokenClient.obtainTokenUsingRefreshToken(refreshToken, clientId, clientSecret);
                accessToken = response.getAccessToken();
                mssoContext.onAccessTokenAvailable(accessToken, response.getRefreshToken(), response.getExpiresIn(), response.getGrantedScope());
            }
            catch (OAuthServerException tse) {
                this.rethrowOrIgnore(tse);
                mssoContext.clearAccessToken();
                accessToken = null;
                if (!MAS.DEBUG) break block3;
                Log.w((String)"MAS", (String)("Refresh token failed, will fall back to ID token or password: " + tse.getMessage()), (Throwable)tse);
            }
        }
        return accessToken;
    }

    private void rethrowOrIgnore(OAuthServerException e) throws OAuthServerException {
        switch (e.getErrorCode()) {
            case 3003107: 
            case 3003115: 
            case 3003201: 
            case 3003206: {
                throw e;
            }
        }
    }
}

