/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.datasource;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.provider.BaseColumns;
import android.support.annotation.NonNull;
import android.util.Pair;
import com.ca.mas.core.datasource.DataConverter;
import com.ca.mas.core.datasource.DataSource;
import com.ca.mas.core.datasource.DataSourceCallback;
import com.ca.mas.core.datasource.DataSourceException;
import com.ca.mas.core.datasource.LocalStoreEntity;
import com.ca.mas.core.datasource.LocalStoreKey;
import com.ca.mas.core.storage.StorageException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;

public class LocalStoreDataSource
implements DataSource<LocalStoreKey, LocalStoreEntity> {
    private Context context;
    private LocalStorageDbHelper mLocalStorageDbHelper = null;

    public LocalStoreDataSource(Context context, JSONObject param, DataConverter converter) {
        this.context = context.getApplicationContext();
        try {
            this.mLocalStorageDbHelper = new LocalStorageDbHelper(this.context);
            this.mLocalStorageDbHelper.getDatabaseHandle();
        }
        catch (Exception e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public void put(@NonNull LocalStoreKey key, @NonNull LocalStoreEntity localStoreItem) {
        SQLiteDatabase myDatabase = null;
        try {
            myDatabase = this.mLocalStorageDbHelper.getDatabaseHandle();
            ContentValues values = new ContentValues();
            values.put("key", key.getKey());
            if (key.getCreatedBy() == null) {
                values.putNull("created_by");
            } else {
                values.put("created_by", key.getCreatedBy());
            }
            values.put("segment", key.getSegment());
            values.put("value", localStoreItem.getData());
            values.put("content_type", localStoreItem.getType());
            values.put("last_updated_date", Long.valueOf(new Date().getTime()));
            long rowID = myDatabase.insertWithOnConflict("LocalStore", null, values, 5);
            if (rowID == -1L) {
                throw new StorageException(110);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error in put() ", e);
        }
    }

    @Override
    public void put(LocalStoreKey key, LocalStoreEntity localStoreItem, DataSourceCallback dataSourceCallback) {
        throw new DataSourceException("Not Implemented");
    }

    @Override
    public LocalStoreEntity get(@NonNull LocalStoreKey key) {
        SQLiteDatabase myDatabase = null;
        try {
            myDatabase = this.mLocalStorageDbHelper.getDatabaseHandle();
            String[] columns = new String[]{"value", "content_type"};
            Pair<String, String[]> selection = this.getSelection(key);
            Cursor resultCursor = myDatabase.query("LocalStore", columns, (String)selection.first, (String[])selection.second, null, null, null, null);
            if (resultCursor.getCount() == 0) {
                return null;
            }
            resultCursor.moveToFirst();
            byte[] value = resultCursor.getBlob(resultCursor.getColumnIndexOrThrow("value"));
            String type = resultCursor.getString(resultCursor.getColumnIndexOrThrow("content_type"));
            resultCursor.close();
            return new LocalStoreEntity(type, value);
        }
        catch (Exception e) {
            throw new DataSourceException("Error in get() ", e);
        }
    }

    @Override
    public void get(LocalStoreKey s, DataSourceCallback dataSourceCallback) {
        throw new DataSourceException("Not Implemented");
    }

    @Override
    public void remove(@NonNull LocalStoreKey key) {
        SQLiteDatabase myDatabase = null;
        try {
            this.get(key);
            myDatabase = this.mLocalStorageDbHelper.getDatabaseHandle();
            Pair<String, String[]> selection = this.getSelection(key);
            int val = myDatabase.delete("LocalStore", (String)selection.first, (String[])selection.second);
            if (val < 0) {
                throw new StorageException(110);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error in remove() ", e);
        }
    }

    @Override
    public void remove(LocalStoreKey s, DataSourceCallback dataSourceCallback) {
        throw new DataSourceException("Not Implemented");
    }

    @Override
    public void removeAll(Object filter) {
        SQLiteDatabase myDatabase = null;
        try {
            myDatabase = this.mLocalStorageDbHelper.getDatabaseHandle();
            Pair<String, String[]> selection = this.getSelection((LocalStoreKey)filter);
            int val = myDatabase.delete("LocalStore", (String)selection.first, (String[])selection.second);
            if (val < 0) {
                throw new StorageException(110);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error in removeAll() ", e);
        }
    }

    @Override
    public void removeAll(Object filter, DataSourceCallback dataSourceCallback) {
        throw new DataSourceException("Not Implemented");
    }

    @Override
    public List<LocalStoreKey> getKeys(Object filter) {
        SQLiteDatabase myDatabase = null;
        ArrayList<LocalStoreKey> allKeys = new ArrayList<LocalStoreKey>();
        try {
            myDatabase = this.mLocalStorageDbHelper.getWritableDatabase();
            String[] columns = new String[]{"key", "segment", "created_by"};
            Pair<String, String[]> selection = this.getSelection((LocalStoreKey)filter);
            Cursor resultCursor = myDatabase.query("LocalStore", columns, (String)selection.first, (String[])selection.second, null, null, null);
            if (resultCursor.getCount() != 0) {
                resultCursor.moveToFirst();
                while (!resultCursor.isAfterLast()) {
                    allKeys.add(new LocalStoreKey(resultCursor.getString(resultCursor.getColumnIndexOrThrow("key")), resultCursor.getInt(resultCursor.getColumnIndexOrThrow("segment")), resultCursor.getString(resultCursor.getColumnIndexOrThrow("created_by"))));
                    resultCursor.moveToNext();
                }
                resultCursor.close();
            }
            return allKeys;
        }
        catch (Exception e) {
            throw new DataSourceException("error getKeys()", e);
        }
    }

    private Pair<String, String[]> getSelection(LocalStoreKey key) {
        StringBuilder selection = new StringBuilder();
        ArrayList<String> selectionArgs = new ArrayList<String>();
        if (key.getKey() != null) {
            selection.append("key");
            selection.append(" =? ");
            selectionArgs.add(key.getKey());
        }
        if (selection.length() != 0 && key.getSegment() != null) {
            selection.append(" AND ");
        }
        if (key.getSegment() != null) {
            selection.append("segment");
            selection.append(" =? ");
            selectionArgs.add(Integer.toString(key.getSegment()));
        }
        if (selection.length() != 0 && key.getCreatedBy() != null) {
            selection.append(" AND ");
        }
        if (key.getCreatedBy() != null) {
            selection.append("created_by");
            selection.append(" =? ");
            selectionArgs.add(key.getCreatedBy());
        }
        return new Pair((Object)selection.toString(), (Object)selectionArgs.toArray(new String[selectionArgs.size()]));
    }

    @Override
    public void getKeys(Object filter, DataSourceCallback dataSourceCallback) {
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void unlock() {
    }

    private class LocalStorageDbHelper
    extends SQLiteOpenHelper {
        public static final int DATABASE_VERSION = 2;
        private static final String DATABASE_NAME = "LS.db";
        private static final String TEXT_TYPE = " TEXT";
        private static final String INT_TYPE = " INTEGER";
        private static final String BLOB_TYPE = " BLOB";
        private static final String DATETIME_TYPE = " DATETIME";
        private static final String SQL_CREATE_ENTRIES = "CREATE TABLE LocalStore (key TEXT NOT NULL,value BLOB NOT NULL,content_type TEXT NOT NULL,segment INTEGER NOT NULL,created_by TEXT NOT NULL,created_date DATETIME  DEFAULT CURRENT_TIMESTAMP, last_updated_date DATETIME  DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (key,segment,created_by) )";
        private final String SQL_DELETE_ENTRIES = "DROP TABLE IF EXISTS LocalStore";

        public LocalStorageDbHelper(Context context) {
            super(context, DATABASE_NAME, null, 2);
            this.SQL_DELETE_ENTRIES = "DROP TABLE IF EXISTS LocalStore";
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL(SQL_CREATE_ENTRIES);
        }

        public void onUpgrade(SQLiteDatabase db, int i, int i1) {
            db.execSQL("DROP TABLE IF EXISTS LocalStore");
            this.onCreate(db);
        }

        public SQLiteDatabase getDatabaseHandle() throws SQLiteException {
            return this.getWritableDatabase();
        }
    }

    private final class LocalStorageContract {

        public abstract class LocalStorageEntry
        implements BaseColumns {
            public static final String TABLE_NAME = "LocalStore";
            public static final String COLUMN_KEY = "key";
            public static final String COLUMN_VALUE = "value";
            public static final String COLUMN_TYPE = "content_type";
            public static final String COLUMN_CREATED_BY = "created_by";
            public static final String COLUMN_CREATED_DATE = "created_date";
            public static final String COLUMN_LAST_UPDATED_DATE = "last_updated_date";
            public static final String COLUMN_SEGMENT = "segment";
        }
    }
}

