/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.client;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ServerResponse {
    protected int status;
    protected int errorCode;
    protected final String json;
    protected final JSONObject parsed;

    public ServerResponse(int status, String json) throws JSONException {
        this(status, 0, json);
    }

    public ServerResponse(int status, int errorCode, String json) throws JSONException {
        this.errorCode = errorCode;
        this.status = status;
        if (json == null) {
            throw new NullPointerException("json");
        }
        this.json = json;
        Object got = new JSONTokener(json).nextValue();
        if (got == null) {
            throw new JSONException("JSON response parsed to NULL");
        }
        if (!(got instanceof JSONObject)) {
            throw new JSONException("JSON response did not contain a JSON object");
        }
        this.parsed = (JSONObject)got;
    }

    public int getStatus() {
        return this.status;
    }

    public String getJson() {
        return this.json;
    }

    public boolean isError() {
        return 0 != this.errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

