/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.auth.otp;

import com.ca.mas.core.auth.otp.model.OtpResponseBody;
import com.ca.mas.core.auth.otp.model.OtpResponseHeaders;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class OtpUtil {
    private OtpUtil() {
    }

    public static OtpResponseHeaders getXotpValueFromHeaders(Map<String, List<String>> headers) {
        OtpResponseHeaders otpHeaders = new OtpResponseHeaders();
        if (headers != null) {
            List<String> errorCodeList;
            String otpRetryInterval;
            List<String> otpRetryIntervalList;
            String otpRetry;
            List<String> otpRetryList;
            List<String> otpChannelList;
            List<String> otpStatusList = headers.get("X-OTP");
            if (otpStatusList != null && !otpStatusList.isEmpty()) {
                String otpStatus = otpStatusList.get(0);
                OtpResponseHeaders.X_OTP_VALUE otpValue = OtpUtil.convertOtpStatusToEnum(otpStatus);
                otpHeaders.setxOtpValue(otpValue);
            }
            if ((otpChannelList = headers.get("X-OTP-CHANNEL")) != null && otpChannelList.get(0) != null) {
                String channels = otpChannelList.get(0);
                String[] channelsStringArray = channels.split(",");
                otpHeaders.setChannels(Arrays.asList(channelsStringArray));
            }
            if ((otpRetryList = headers.get("X-OTP-RETRY")) != null && !otpRetryList.isEmpty() && (otpRetry = otpRetryList.get(0)) != null && !"".equals(otpRetry)) {
                otpHeaders.setRetry(Integer.decode(otpRetry));
            }
            if ((otpRetryIntervalList = headers.get("X-OTP-RETRY-INTERVAL")) != null && !otpRetryIntervalList.isEmpty() && (otpRetryInterval = otpRetryIntervalList.get(0)) != null && !"".equals(otpRetryInterval)) {
                otpHeaders.setRetryInterval(Integer.decode(otpRetryInterval));
            }
            if ((errorCodeList = headers.get("x-ca-err")) != null && !errorCodeList.isEmpty()) {
                String xCaError = errorCodeList.get(0);
                OtpResponseHeaders.X_CA_ERROR error = OtpUtil.convertOtpErrorCodeToEnum(xCaError);
                otpHeaders.setErrorCode(error);
            }
        }
        return otpHeaders;
    }

    private static OtpResponseHeaders.X_OTP_VALUE convertOtpStatusToEnum(String otpStatus) {
        switch (otpStatus) {
            case "required": {
                return OtpResponseHeaders.X_OTP_VALUE.REQUIRED;
            }
            case "generated": {
                return OtpResponseHeaders.X_OTP_VALUE.GENERATED;
            }
            case "invalid": {
                return OtpResponseHeaders.X_OTP_VALUE.INVALID;
            }
            case "expired": {
                return OtpResponseHeaders.X_OTP_VALUE.EXPIRED;
            }
            case "suspended": {
                return OtpResponseHeaders.X_OTP_VALUE.SUSPENDED;
            }
        }
        return OtpResponseHeaders.X_OTP_VALUE.UNKNOWN;
    }

    public static OtpResponseHeaders.X_CA_ERROR convertOtpErrorCodeToEnum(String errorCode) {
        switch (errorCode) {
            case "8000140": {
                return OtpResponseHeaders.X_CA_ERROR.REQUIRED;
            }
            case "8000142": {
                return OtpResponseHeaders.X_CA_ERROR.OTP_INVALID;
            }
            case "8000143": {
                return OtpResponseHeaders.X_CA_ERROR.EXPIRED;
            }
            case "8000144": {
                return OtpResponseHeaders.X_CA_ERROR.OTP_MAX_RETRY_EXCEEDED;
            }
            case "8000145": {
                return OtpResponseHeaders.X_CA_ERROR.SUSPENDED;
            }
            case "8000400": {
                return OtpResponseHeaders.X_CA_ERROR.INVALID_USER_INPUT;
            }
            case "8000500": {
                return OtpResponseHeaders.X_CA_ERROR.INTERNAL_SERVER_ERROR;
            }
        }
        return OtpResponseHeaders.X_CA_ERROR.UNKNOWN;
    }

    public static OtpResponseBody parseOtpResponseBody(String body) {
        OtpResponseBody otpResponseBody = new OtpResponseBody();
        try {
            JSONObject jsonObj = new JSONObject(body);
            otpResponseBody.setError(jsonObj.getString("error"));
            otpResponseBody.setErrorDescription(jsonObj.getString("error_description"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return otpResponseBody;
    }
}

