/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.identity.group;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.ca.mas.identity.common.Attribute;
import com.ca.mas.identity.common.Attributes;
import com.ca.mas.identity.util.IdentityUtil;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GroupAttributes
extends Attributes {
    @Override
    public void populate(@NonNull JSONObject jobj) throws JSONException {
        ArrayList<Attribute> mGroupAttributes = new ArrayList<Attribute>();
        IdentityUtil.SCHEMA_MAP.put("groupAttributesKey", jobj);
        JSONArray jsonAttribs = jobj.optJSONArray("attributes");
        for (int attrIndex = 0; attrIndex < jsonAttribs.length(); ++attrIndex) {
            JSONObject attribObj = jsonAttribs.getJSONObject(attrIndex);
            if (attribObj == null) continue;
            Attribute attribute = new Attribute();
            attribute.populate(attribObj);
            mGroupAttributes.add(attribute);
            String name = attribObj.optString("name");
            if (TextUtils.isEmpty((CharSequence)name)) continue;
            JSONArray subAttribs = attribObj.optJSONArray("subAttributes");
            if (subAttribs != null) {
                for (int subAttrIndex = 0; subAttrIndex < subAttribs.length(); ++subAttrIndex) {
                    JSONObject subAttrib = subAttribs.optJSONObject(subAttrIndex);
                    if (subAttrib == null) continue;
                    Attribute subAttribute = new Attribute();
                    subAttribute.populate(subAttrib);
                    mGroupAttributes.add(subAttribute);
                    String subName = subAttrib.optString("name");
                    if (TextUtils.isEmpty((CharSequence)subName)) continue;
                    this.mAttributes.add(name + "." + subName);
                }
                continue;
            }
            this.mAttributes.add(name);
        }
    }

    @Override
    protected String getKey() {
        return "groupAttributesKey";
    }
}

