/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.net.Uri;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.request.internal.LocalRequest;
import com.ca.mas.core.request.internal.MAGRequestProxy;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASResponseBody;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MASTokenRequest
extends MAGRequestProxy
implements LocalRequest<JSONObject> {
    private static final String ACCESS_TOKEN = "access_token";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String EXPIRES_IN = "expires_in";

    public MASTokenRequest() {
        this.request = new MASRequest.MASRequestBuilder(new Uri.Builder().appendPath("token").build()).build();
    }

    public MASTokenRequest(MASRequest request) {
        this.request = request;
    }

    @Override
    public MASResponse<JSONObject> send(final MssoContext context) throws IOException {
        return new MASResponse<JSONObject>(){

            @Override
            public Map<String, List<String>> getHeaders() {
                return null;
            }

            @Override
            public int getResponseCode() {
                return 200;
            }

            @Override
            public String getResponseMessage() {
                return null;
            }

            @Override
            public MASResponseBody<JSONObject> getBody() {
                return new MASResponseBody<JSONObject>(){

                    @Override
                    public JSONObject getContent() {
                        JSONObject entity = new JSONObject();
                        try {
                            entity.put(MASTokenRequest.ACCESS_TOKEN, (Object)context.getAccessToken());
                            entity.put(MASTokenRequest.REFRESH_TOKEN, (Object)context.getRefreshToken());
                            entity.put(MASTokenRequest.EXPIRES_IN, context.getAccessTokenExpiry());
                        }
                        catch (JSONException e) {
                            return new JSONObject();
                        }
                        return entity;
                    }
                };
            }
        };
    }
}

