/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.util.Log;
import com.ca.mas.core.io.IoUtils;
import com.ca.mas.foundation.MAS;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class MASResponseBody<T> {
    private static final int DEFAULT_MAX_RESPONSE_SIZE = 0xA00000;
    private String contentType;
    private int contentLength;
    protected byte[] buffer = new byte[0];

    public T getContent() {
        if (this.contentType != null) {
            if (this.contentType.contains("application/json")) {
                try {
                    if (this.buffer == null || this.buffer.length == 0) {
                        return (T)new JSONObject();
                    }
                    return (T)new JSONObject(new String(this.buffer));
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.contentType.contains("text/plain")) {
                if (this.buffer == null || this.buffer.length == 0) {
                    return (T)"";
                }
                return (T)new String(this.buffer);
            }
        }
        return (T)this.buffer;
    }

    public byte[] getRawContent() {
        return this.buffer;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void read(HttpURLConnection httpURLConnection) throws IOException {
        this.contentType = httpURLConnection.getContentType();
        this.contentLength = httpURLConnection.getContentLength();
        InputStream inputStream = httpURLConnection.getErrorStream();
        if (inputStream == null) {
            inputStream = httpURLConnection.getInputStream();
        }
        this.buffer = IoUtils.slurpStream(inputStream, 0xA00000);
        if (MAS.DEBUG) {
            String s = "";
            try {
                s = new String(this.buffer);
                JSONObject j = new JSONObject(s);
                Log.d((String)"MAS", (String)String.format("Response content: %s", j.toString(4)));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            Log.d((String)"MAS", (String)String.format("Response content: %s", s));
        }
    }

    public static MASResponseBody<byte[]> byteArrayBody() {
        return new MASResponseBody<byte[]>(){

            @Override
            public byte[] getContent() {
                return this.buffer;
            }
        };
    }

    public static MASResponseBody<JSONObject> jsonBody() {
        return new MASResponseBody<JSONObject>(){

            @Override
            public JSONObject getContent() {
                if (this.buffer == null || this.buffer.length == 0) {
                    return new JSONObject();
                }
                try {
                    return new JSONObject(new String(this.buffer));
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static MASResponseBody<String> stringBody() {
        return new MASResponseBody<String>(){

            @Override
            public String getContent() {
                if (this.buffer == null || this.buffer.length == 0) {
                    return "";
                }
                return new String(this.buffer);
            }
        };
    }
}

