/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.app.Activity;
import android.app.Application;
import android.content.AsyncTaskLoader;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.Base64;
import android.util.Log;
import com.ca.mas.core.EventDispatcher;
import com.ca.mas.core.MAGResultReceiver;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.client.ServerClient;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.foundation.AuthenticationListener;
import com.ca.mas.foundation.Internal;
import com.ca.mas.foundation.JWTSign;
import com.ca.mas.foundation.MASAuthenticationListener;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASClaims;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASConnectionListener;
import com.ca.mas.foundation.MASDevice;
import com.ca.mas.foundation.MASException;
import com.ca.mas.foundation.MASGrantProvider;
import com.ca.mas.foundation.MASMultiFactorAuthenticator;
import com.ca.mas.foundation.MASOtpMultiFactorAuthenticator;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASResponseBody;
import com.ca.mas.foundation.MASResponseProxy;
import com.ca.mas.foundation.MASSecurityConfiguration;
import com.ca.mas.foundation.MASServerException;
import com.ca.mas.foundation.notify.Callback;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.security.PrivateKey;
import org.json.JSONObject;

public class MAS {
    public static final String TAG = "MAS";
    public static boolean DEBUG = Log.isLoggable((String)"MAS", (int)2);
    private static Context appContext;
    private static Activity currentActivity;
    private static boolean hasRegisteredActivityCallback;
    private static MASAuthenticationListener masAuthenticationListener;
    private static MASOtpMultiFactorAuthenticator otpMultiFactorAuthenticator;
    private static int state;
    private static boolean browserBasedAuthenticationEnabled;

    private MAS() {
    }

    private static synchronized void init(@NonNull Context context) {
        MAS.stop();
        appContext = context.getApplicationContext();
        if (context instanceof Activity) {
            currentActivity = (Activity)context;
        }
        MAS.registerActivityLifecycleCallbacks((Application)appContext);
        new MASConfiguration(appContext);
        ConfigurationManager.getInstance().setMobileSsoListener(new AuthenticationListener(appContext));
        MAS.registerMultiFactorAuthenticator(otpMultiFactorAuthenticator);
    }

    private static void registerActivityLifecycleCallbacks(Application application) {
        if (hasRegisteredActivityCallback) {
            return;
        }
        hasRegisteredActivityCallback = true;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                currentActivity = activity;
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
                Activity currentActivity;
                if (currentActivity != null && (currentActivity = currentActivity) == activity) {
                    currentActivity = null;
                }
            }
        });
    }

    public static void debug() {
        DEBUG = true;
    }

    public static void start(@NonNull Context context) {
        MAS.init(context);
        MobileSsoFactory.getInstance(context);
        state = 3;
        EventDispatcher.STARTED.notifyObservers();
    }

    public static void start(@NonNull Context context, boolean shouldUseDefault) {
        MAS.init(context);
        MobileSsoFactory.getInstance(context, shouldUseDefault);
        state = 3;
        EventDispatcher.STARTED.notifyObservers();
    }

    public static void start(@NonNull Context context, JSONObject jsonConfiguration) {
        MAS.init(context);
        MobileSsoFactory.getInstance(context, jsonConfiguration);
        state = 3;
        EventDispatcher.STARTED.notifyObservers();
    }

    public static void start(@NonNull Context context, URL url) {
        MAS.init(context);
        MobileSsoFactory.getInstance(context, url);
        state = 3;
        EventDispatcher.STARTED.notifyObservers();
    }

    public static void start(final @NonNull Context context, final URL url, final MASCallback<Void> callback) {
        if (url == null) {
            try {
                MAS.start(context);
                Callback.onSuccess(callback, null);
            }
            catch (Exception e) {
                Callback.onError(callback, e);
            }
            return;
        }
        final Uri uri = Uri.parse((String)url.toString());
        final String publicKeyHash = uri.getQueryParameter("subjectKeyHash");
        if (publicKeyHash == null || publicKeyHash.trim().isEmpty()) {
            Callback.onError(callback, new IllegalArgumentException("subjectKeyHash is not provided."));
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    String pkh = Base64.encodeToString((byte[])Base64.decode((String)publicKeyHash, (int)10), (int)2);
                    MASSecurityConfiguration enrollmentConfig = new MASSecurityConfiguration.Builder().add(pkh).host(uri).build();
                    MAGHttpClient client = new MAGHttpClient();
                    MASRequest request = new MASRequest.MASRequestBuilder(url).responseBody(MASResponseBody.jsonBody()).setPublic().build();
                    MASResponse response = client.execute(request, enrollmentConfig);
                    if (response.getResponseCode() != 200) {
                        throw ServerClient.createServerException(response, MASServerException.class);
                    }
                    MAS.start(context, (JSONObject)response.getBody().getContent());
                    Callback.onSuccess(callback, null);
                }
                catch (Exception e) {
                    Callback.onError(callback, e);
                }
                return null;
            }
        }.execute((Object[])new Void[]{null});
    }

    public static <T> long invoke(final MASRequest request, final MASCallback<MASResponse<T>> callback) {
        return MobileSsoFactory.getInstance().processRequest(request, new MAGResultReceiver<T>(Callback.getHandler(callback)){

            @Override
            public void onSuccess(MASResponse<T> response) {
                Callback.onSuccess(callback, new MASResponseProxy(response));
            }

            @Override
            public void onError(MAGError error) {
                Callback.onError(callback, error);
            }

            @Override
            public void onRequestCancelled(Bundle data) {
                if (request.notifyOnCancel()) {
                    Callback.onError(callback, new RequestCancelledException(data));
                }
            }
        });
    }

    public static void setConfigurationFileName(String filename) {
        ConfigurationManager.getInstance().setConfigurationFileName(filename);
    }

    public static void gatewayIsReachable(final MASCallback<Boolean> callback) {
        new AsyncTaskLoader<Void>(MAS.getContext()){

            protected void onStartLoading() {
                super.onStartLoading();
                this.forceLoad();
            }

            public Void loadInBackground() {
                try {
                    Callback.onSuccess(callback, InetAddress.getByName(ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTokenHost()).isReachable(1000));
                }
                catch (IOException e) {
                    Callback.onSuccess(callback, false);
                }
                return null;
            }
        }.startLoading();
    }

    public static void setConnectionListener(MASConnectionListener listener) {
        ConfigurationManager.getInstance().setConnectionListener(listener);
    }

    public static void setAuthenticationListener(MASAuthenticationListener listener) {
        masAuthenticationListener = listener;
    }

    static MASAuthenticationListener getAuthenticationListener() {
        return masAuthenticationListener;
    }

    public static boolean isAuthenticationListenerRegistered() {
        return masAuthenticationListener != null;
    }

    public static void setGrantFlow(int type) {
        switch (type) {
            case 1: {
                ConfigurationManager.getInstance().setDefaultGrantProvider(MASGrantProvider.CLIENT_CREDENTIALS);
                break;
            }
            case 2: {
                ConfigurationManager.getInstance().setDefaultGrantProvider(MASGrantProvider.PASSWORD);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Flow Type");
            }
        }
    }

    @Internal
    public static Context getContext() {
        return appContext;
    }

    @Internal
    public static Activity getCurrentActivity() {
        return currentActivity;
    }

    public static void cancelRequest(long requestId) {
        MobileSsoFactory.getInstance().cancelRequest(requestId, null);
    }

    public static void cancelRequest(long requestId, Bundle data) {
        MobileSsoFactory.getInstance().cancelRequest(requestId, data);
    }

    public static void cancelAllRequests() {
        MobileSsoFactory.getInstance().cancelAllRequests(null);
    }

    public static void cancelAllRequest(Bundle data) {
        MobileSsoFactory.getInstance().cancelAllRequests(data);
    }

    public static void processPendingRequests() {
        MobileSsoFactory.getInstance().processPendingRequests();
    }

    public static int getState(Context context) {
        if (state != 0) {
            return state;
        }
        ConfigurationManager.getInstance().init(context);
        try {
            ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider();
            ConfigurationManager.getInstance().reset();
            state = 2;
        }
        catch (Exception e) {
            state = 1;
        }
        return state;
    }

    public static void enablePKCE(boolean enablePKCE) {
        ConfigurationManager.getInstance().enablePKCE(enablePKCE);
    }

    public static boolean isPKCEEnabled() {
        return ConfigurationManager.getInstance().isPKCEEnabled();
    }

    public static void stop() {
        state = 4;
        EventDispatcher.STOP.notifyObservers();
        MobileSsoFactory.reset();
    }

    public static String sign(MASClaims masClaims) throws MASException {
        return MAS.sign(masClaims, StorageProvider.getInstance().getTokenManager().getClientPrivateKey());
    }

    public static String sign(MASClaims masClaims, PrivateKey privateKey) throws MASException {
        if (!MASDevice.getCurrentDevice().isRegistered()) {
            throw new IllegalStateException("Device not registered.");
        }
        return JWTSign.sign(masClaims, privateKey);
    }

    public static void enableBrowserBasedAuthentication() {
        browserBasedAuthenticationEnabled = true;
    }

    public static boolean isBrowserBasedAuthenticationEnabled() {
        return browserBasedAuthenticationEnabled;
    }

    public static void registerMultiFactorAuthenticator(MASMultiFactorAuthenticator authenticator) {
        ConfigurationManager.getInstance().registerResponseInterceptor(authenticator);
    }

    private static void unregisterMultiFactorAuthenticator(MASMultiFactorAuthenticator authenticator) {
        ConfigurationManager.getInstance().unregisterResponseInterceptor(authenticator);
    }

    static {
        otpMultiFactorAuthenticator = new MASOtpMultiFactorAuthenticator();
        browserBasedAuthenticationEnabled = false;
    }

    public static class RequestCancelledException
    extends Exception {
        private final Bundle data;

        public RequestCancelledException(Bundle data) {
            this.data = data;
        }

        public Bundle getData() {
            return this.data;
        }
    }
}

