/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.policy.AccessTokenAssertion;
import com.ca.mas.core.policy.ClientCredentialAssertion;
import com.ca.mas.core.policy.CustomHeaderAssertion;
import com.ca.mas.core.policy.DeviceRegistrationAssertion;
import com.ca.mas.core.policy.LocationAssertion;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.ResponseRecoveryAssertion;
import com.ca.mas.core.policy.SecureLockAssertion;
import com.ca.mas.core.policy.StorageReadyAssertion;
import com.ca.mas.core.policy.TelephoneAssertion;
import com.ca.mas.foundation.MASResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PolicyManager {
    private final MssoContext mssoContext;
    private final List<MssoAssertion> defaultPolicy = new ArrayList<MssoAssertion>();
    private final Object policySync = new Object();

    public PolicyManager(MssoContext mssoContext) {
        this.mssoContext = mssoContext;
        this.defaultPolicy.add(new StorageReadyAssertion());
        this.defaultPolicy.add(new SecureLockAssertion());
        this.defaultPolicy.add(new ClientCredentialAssertion());
        this.defaultPolicy.add(new DeviceRegistrationAssertion());
        this.defaultPolicy.add(new AccessTokenAssertion());
        this.defaultPolicy.add(new LocationAssertion());
        this.defaultPolicy.add(new TelephoneAssertion());
        this.defaultPolicy.add(new CustomHeaderAssertion());
        this.defaultPolicy.add(new ResponseRecoveryAssertion());
    }

    public void init(Context sysContext) {
        this.init(sysContext, this.defaultPolicy);
    }

    private void init(Context sysContext, List<MssoAssertion> policy) {
        Context appContext = sysContext.getApplicationContext();
        for (MssoAssertion assertion : policy) {
            assertion.init(this.mssoContext, appContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(RequestInfo request, List<MssoAssertion> policy) throws MAGException, MAGServerException {
        Object object = this.policySync;
        synchronized (object) {
            for (MssoAssertion assertion : policy) {
                assertion.processRequest(this.mssoContext, request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(RequestInfo request, MASResponse response, List<MssoAssertion> policy) throws MAGException, MAGServerException {
        Object object = this.policySync;
        synchronized (object) {
            for (MssoAssertion assertion : policy) {
                assertion.processResponse(this.mssoContext, request, response);
            }
        }
    }

    public MASResponse execute(RequestInfo requestInfo, Route<MASResponse> function) throws MAGException, MAGServerException, IOException {
        this.processRequest(requestInfo, this.defaultPolicy);
        MASResponse response = function.invoke();
        this.processResponse(requestInfo, response, this.defaultPolicy);
        return response;
    }

    public void close() {
        this.close(this.defaultPolicy);
    }

    private void close(List<MssoAssertion> policy) {
        for (MssoAssertion assertion : policy) {
            assertion.close();
        }
    }

    public static interface Route<R> {
        public R invoke() throws IOException;
    }
}

