/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.annotation.TargetApi;
import android.content.AsyncTaskLoader;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Parcel;
import android.security.keystore.UserNotAuthenticatedException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.core.EventDispatcher;
import com.ca.mas.core.MAGResultReceiver;
import com.ca.mas.core.MobileSso;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.security.LockableEncryptionProvider;
import com.ca.mas.core.security.SecureLockException;
import com.ca.mas.core.storage.Storage;
import com.ca.mas.core.storage.StorageException;
import com.ca.mas.core.storage.StorageResult;
import com.ca.mas.core.storage.implementation.MASStorageManager;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.core.store.TokenStoreException;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.core.token.JWTValidation;
import com.ca.mas.core.util.Functions;
import com.ca.mas.foundation.Extension;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASAuthCredentialsAuthorizationCode;
import com.ca.mas.foundation.MASAuthCredentialsJWT;
import com.ca.mas.foundation.MASAuthCredentialsPassword;
import com.ca.mas.foundation.MASAuthorizationRequest;
import com.ca.mas.foundation.MASAuthorizationRequestHandler;
import com.ca.mas.foundation.MASAuthorizationResponse;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASExtension;
import com.ca.mas.foundation.MASGroup;
import com.ca.mas.foundation.MASIdToken;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASSessionUnlockCallback;
import com.ca.mas.foundation.UserInfoRepository;
import com.ca.mas.foundation.UserRepository;
import com.ca.mas.foundation.notify.Callback;
import com.ca.mas.identity.common.MASFilteredRequest;
import com.ca.mas.identity.user.MASUserIdentity;
import com.ca.mas.identity.user.MASUserRepository;
import com.ca.mas.identity.user.ScimUser;
import com.ca.mas.identity.user.User;
import com.ca.mas.identity.user.UserAttributes;
import com.ca.mas.identity.util.IdentityUtil;
import com.ca.mas.messaging.MASMessage;
import com.ca.mas.messaging.MASMessenger;
import com.ca.mas.messaging.topic.MASTopic;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MASUser
implements MASMessenger,
MASUserIdentity,
ScimUser {
    private static final String SESSION_LOCK_ALIAS = "com.ca.mas.SESSION_LOCK";
    private static MASUser current;

    public static void login(MASAuthorizationRequest request, MASAuthorizationRequestHandler handler) {
        handler.authorize(request);
    }

    @Deprecated
    public static void login(@NonNull String userName, @NonNull String password, MASCallback<MASUser> callback) {
        MASUser.login(userName, password.toCharArray(), callback);
    }

    public static void login(@NonNull String userName, @NonNull char[] cPassword, MASCallback<MASUser> callback) {
        MASUser.login(new MASAuthCredentialsPassword(userName, cPassword), callback);
    }

    public static void login(MASIdToken idToken, MASCallback<MASUser> callback) {
        MASUser.login(new MASAuthCredentialsJWT(idToken), callback);
    }

    public static void login(MASAuthCredentials credentials, final MASCallback<MASUser> callback) {
        MobileSso mobileSso = MobileSsoFactory.getInstance();
        mobileSso.authenticate(credentials, new MAGResultReceiver<JSONObject>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> response) {
                MASUser.login(callback);
            }

            @Override
            public void onError(MAGError error) {
                current = null;
                Callback.onError(callback, error);
                MAS.processPendingRequests();
            }
        });
    }

    public static void login(final MASCallback<MASUser> callback) {
        final MASUser user = MASUser.createMASUser();
        user.requestUserInfo(new MASCallback<Void>(){

            @Override
            public void onSuccess(Void result) {
                current = user;
                Callback.onSuccess(callback, current);
                MAS.processPendingRequests();
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
                MAS.processPendingRequests();
            }
        });
    }

    public static void login(@NonNull MASAuthorizationResponse authorizationResponse, MASCallback<MASUser> callback) {
        MASUser.login(new MASAuthCredentialsAuthorizationCode(authorizationResponse.getAuthorizationCode(), authorizationResponse.getState()), callback);
    }

    public static MASUser getCurrentUser() {
        TokenManager tokenManager;
        if (current == null && (tokenManager = StorageProvider.getInstance().getTokenManager()).getUserProfile() != null) {
            current = MASUser.createMASUser();
        }
        if (current != null && !current.isAuthenticated() && !current.isSessionLocked()) {
            current = null;
        }
        return current;
    }

    public abstract String getAccessToken();

    private static MASUser createMASUser() {
        User user;
        block3: {
            user = new User(){
                @MASExtension
                private MASMessenger masMessenger;
                @MASExtension
                private MASUserRepository userRepository;

                @Override
                public boolean isAuthenticated() {
                    return MobileSsoFactory.getInstance().isLogin();
                }

                @Override
                public boolean isCurrentUser() {
                    return true;
                }

                @Override
                public void sendMessage(final MASTopic topic, final MASMessage message, final MASCallback<Void> callback) {
                    this.execute(new Functions.NullaryVoid(){

                        @Override
                        public void call() {
                            masMessenger.sendMessage(topic, message, (MASCallback<Void>)callback);
                        }
                    }, callback);
                }

                @Override
                public void sendMessage(@NonNull MASMessage message, MASUser user, MASCallback<Void> callback) {
                    String userId = user.getId();
                    this.sendMessage(message, user, userId, callback);
                }

                @Override
                public void sendMessage(final @NonNull MASMessage message, final MASUser user, final String topic, final MASCallback<Void> callback) {
                    this.execute(new Functions.NullaryVoid(){

                        @Override
                        public void call() {
                            masMessenger.sendMessage(message, user, topic, (MASCallback<Void>)callback);
                        }
                    }, callback);
                }

                @Override
                public void sendMessage(final @NonNull MASMessage message, final MASGroup group, final MASCallback<Void> callback) {
                    this.execute(new Functions.NullaryVoid(){

                        @Override
                        public void call() {
                            masMessenger.sendMessage(message, group, (MASCallback<Void>)callback);
                        }
                    }, callback);
                }

                @Override
                public void sendMessage(final @NonNull MASMessage message, final MASGroup group, final String topic, final MASCallback<Void> callback) {
                    this.execute(new Functions.NullaryVoid(){

                        @Override
                        public void call() {
                            masMessenger.sendMessage(message, group, topic, (MASCallback<Void>)callback);
                        }
                    }, callback);
                }

                @Override
                public void startListeningToMyMessages(final MASCallback<Void> callback) {
                    this.execute(new Functions.NullaryVoid(){

                        @Override
                        public void call() {
                            masMessenger.startListeningToMyMessages(callback);
                        }
                    }, callback);
                }

                @Override
                public void stopListeningToMyMessages(final MASCallback<Void> callback) {
                    this.execute(new Functions.NullaryVoid(){

                        @Override
                        public void call() {
                            masMessenger.stopListeningToMyMessages(callback);
                        }
                    }, callback);
                }

                private void execute(final Functions.NullaryVoid function, final MASCallback<Void> callback) {
                    if (this.getUserName() == null) {
                        4.login(new MASCallback<MASUser>(){

                            @Override
                            public Handler getHandler() {
                                return Callback.getHandler(callback);
                            }

                            @Override
                            public void onSuccess(MASUser object) {
                                function.call();
                            }

                            @Override
                            public void onError(Throwable e) {
                                Callback.onError(callback, e);
                            }
                        });
                    } else {
                        function.call();
                    }
                }

                @Override
                public void logout(final MASCallback<Void> callback) {
                    current = null;
                    new AsyncTaskLoader<Object>(MAS.getContext()){

                        protected void onStartLoading() {
                            super.onStartLoading();
                            this.forceLoad();
                        }

                        public Object loadInBackground() {
                            try {
                                if (!this.isSessionLocked()) {
                                    MobileSsoFactory.getInstance().logout(true);
                                    Callback.onSuccess(callback, null);
                                } else {
                                    Callback.onError(callback, new SecureLockException("The session is currently locked."));
                                }
                            }
                            catch (Exception e) {
                                Callback.onError(callback, e);
                            }
                            return null;
                        }
                    }.startLoading();
                }

                @Override
                public void getUserById(String id, MASCallback<MASUser> callback) {
                    this.userRepository.getUserById(id, callback);
                }

                @Override
                public void getUsersByFilter(MASFilteredRequest filteredRequest, MASCallback<List<MASUser>> callback) {
                    this.userRepository.getUsersByFilter(filteredRequest, callback);
                }

                @Override
                public void getUserMetaData(MASCallback<UserAttributes> callback) {
                    this.userRepository.getUserMetaData(callback);
                }

                @Override
                public String getAccessToken() {
                    long expiry = StorageProvider.getInstance().getOAuthTokenContainer().getExpiry();
                    if (expiry <= 0L || System.currentTimeMillis() <= expiry) {
                        return StorageProvider.getInstance().getOAuthTokenContainer().getAccessToken();
                    }
                    return null;
                }

                @Override
                public Bitmap getThumbnailImage() {
                    return IdentityUtil.getThumbnail(this.getPhotoList());
                }

                @Override
                public void requestUserInfo(MASCallback<Void> callback) {
                    LinkedList<UserRepository> repositories = new LinkedList<UserRepository>();
                    if (this.userRepository != null) {
                        repositories.add(new UserRepository(){

                            @Override
                            public void getCurrentUser(MASCallback<MASUser> result) {
                                if (this.getUserName() == null) {
                                    userRepository.me(result);
                                } else {
                                    userRepository.getUserById(this.getUserName(), result);
                                }
                            }
                        });
                    }
                    repositories.add(new UserInfoRepository());
                    this.fetch(repositories, callback, null);
                }

                private void fetch(final LinkedList<UserRepository> repositories, final MASCallback<Void> callback, Throwable e) {
                    UserRepository f;
                    try {
                        f = repositories.pop();
                    }
                    catch (NoSuchElementException nse) {
                        Callback.onError(callback, e);
                        return;
                    }
                    try {
                        f.getCurrentUser(new MASCallback<MASUser>(){

                            @Override
                            public void onSuccess(MASUser result) {
                                block2: {
                                    try {
                                        JSONObject source = result.getSource();
                                        source.remove("password");
                                        this.populate(source);
                                        StorageProvider.getInstance().getTokenManager().saveUserProfile(source.toString());
                                    }
                                    catch (Exception e) {
                                        if (!MAS.DEBUG) break block2;
                                        Log.w((String)"MAS", (String)"Unable to persist user profile to local storage.", (Throwable)e);
                                    }
                                }
                                Callback.onSuccess(callback, null);
                            }

                            @Override
                            public void onError(Throwable e) {
                                this.fetch(repositories, callback, e);
                            }
                        });
                    }
                    catch (Exception e1) {
                        this.fetch(repositories, callback, e1);
                    }
                }

                @Override
                @TargetApi(value=23)
                public void lockSession(MASCallback<Void> callback) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        MASUser currentUser = MASUser.getCurrentUser();
                        if (currentUser == null) {
                            Callback.onError(callback, new SecureLockException("No currently authenticated user."));
                        } else if (this.isSessionLocked()) {
                            Callback.onSuccess(callback, null);
                        } else {
                            IdToken idToken = StorageProvider.getInstance().getTokenManager().getIdToken();
                            if (idToken == null) {
                                Callback.onError(callback, new SecureLockException("Failed to retrieve ID token."));
                                return;
                            }
                            try {
                                StorageProvider.getInstance().getOAuthTokenContainer().clear();
                                Parcel idTokenParcel = Parcel.obtain();
                                idToken.writeToParcel(idTokenParcel, 0);
                                byte[] idTokenBytes = idTokenParcel.marshall();
                                LockableEncryptionProvider lockableEncryptionProvider = new LockableEncryptionProvider(MAS.getContext(), MASUser.SESSION_LOCK_ALIAS);
                                lockableEncryptionProvider.clear();
                                byte[] encryptedData = lockableEncryptionProvider.encrypt(idTokenBytes);
                                try {
                                    StorageProvider.getInstance().getTokenManager().saveSecureIdToken(encryptedData);
                                }
                                catch (TokenStoreException e) {
                                    Callback.onError(callback, new SecureLockException("Failed to save encrypted ID token.", e));
                                    return;
                                }
                                try {
                                    StorageProvider.getInstance().getTokenManager().deleteIdToken();
                                }
                                catch (TokenStoreException e) {
                                    Callback.onError(callback, new SecureLockException("Failed to delete encrypted ID token.", e));
                                    return;
                                }
                                idTokenParcel.recycle();
                                Callback.onSuccess(callback, null);
                            }
                            catch (Exception e) {
                                Callback.onError(callback, new SecureLockException("Failed to save encrypted ID token.", e));
                            }
                        }
                    } else {
                        Callback.onError(callback, new IllegalAccessException("Device API level does not meet the target API requirements."));
                    }
                }

                @Override
                public void unlockSession(MASSessionUnlockCallback<Void> callback) {
                    block13: {
                        if (Build.VERSION.SDK_INT >= 23) {
                            if (this.isSessionLocked()) {
                                byte[] secureIdToken = StorageProvider.getInstance().getTokenManager().getSecureIdToken();
                                LockableEncryptionProvider lockableEncryptionProvider = new LockableEncryptionProvider(MAS.getContext(), MASUser.SESSION_LOCK_ALIAS);
                                Parcel parcel = Parcel.obtain();
                                try {
                                    byte[] decryptedData = lockableEncryptionProvider.decrypt(secureIdToken);
                                    parcel.unmarshall(decryptedData, 0, decryptedData.length);
                                    parcel.setDataPosition(0);
                                    IdToken idToken = (IdToken)IdToken.CREATOR.createFromParcel(parcel);
                                    try {
                                        StorageProvider.getInstance().getTokenManager().saveIdToken(idToken);
                                    }
                                    catch (TokenStoreException e) {
                                        Callback.onError(callback, new SecureLockException("Failed to save ID token.", e));
                                        return;
                                    }
                                    try {
                                        StorageProvider.getInstance().getTokenManager().deleteSecureIdToken();
                                    }
                                    catch (TokenStoreException e) {
                                        Callback.onError(callback, new SecureLockException("Failed to delete encrypted ID token.", e));
                                        return;
                                    }
                                    lockableEncryptionProvider.clear();
                                    boolean isTokenExpired = JWTValidation.isIdTokenExpired(idToken);
                                    if (!isTokenExpired) {
                                        Callback.onSuccess(callback, null);
                                        break block13;
                                    }
                                    this.logout(null);
                                    Callback.onError(callback, new SecureLockException("ID token is expired."));
                                }
                                catch (Exception e) {
                                    Throwable t = e.getCause();
                                    if (t != null && (t instanceof UserNotAuthenticatedException || t.getCause() != null && t.getCause() instanceof UserNotAuthenticatedException)) {
                                        if (callback != null) {
                                            callback.onUserAuthenticationRequired();
                                        }
                                        break block13;
                                    }
                                    Callback.onError(callback, e);
                                }
                            } else {
                                Callback.onSuccess(callback, null);
                            }
                        } else {
                            Callback.onError(callback, new IllegalAccessException("Device API level does not meet the target API requirements."));
                        }
                    }
                }

                @Override
                public boolean isSessionLocked() {
                    return StorageProvider.getInstance().getTokenManager().getSecureIdToken() != null;
                }

                @Override
                public void removeSessionLock(MASCallback<Void> callback) {
                    if (!this.isSessionLocked()) {
                        Callback.onSuccess(callback, null);
                    } else {
                        try {
                            StorageProvider.getInstance().getTokenManager().deleteSecureIdToken();
                            Callback.onSuccess(callback, null);
                        }
                        catch (TokenStoreException e) {
                            Callback.onError(callback, new SecureLockException("Failed to delete encrypted ID token.", e));
                        }
                    }
                }
            };
            try {
                JSONObject localUserProfile = MASUser.getLocalUserProfile();
                if (localUserProfile != null) {
                    user.populate(localUserProfile);
                }
            }
            catch (JSONException e) {
                if (!MAS.DEBUG) break block3;
                Log.w((String)"MAS", (String)"Failed to populate MASUser from local storage.", (Throwable)e);
            }
        }
        Extension.inject(user);
        return user;
    }

    private static JSONObject getLocalUserProfile() throws JSONException {
        JSONObject user = null;
        String userProfile = StorageProvider.getInstance().getTokenManager().getUserProfile();
        if (userProfile != null) {
            user = new JSONObject(userProfile);
        }
        return user;
    }

    public static String getAuthCredentialsType() {
        block3: {
            try {
                Storage accountManager = new MASStorageManager().getStorage(MASStorageManager.MASStorageType.TYPE_AMS, (Object)new Object[]{MAS.getContext(), false});
                StorageResult result = accountManager.readData("registration_type");
                if (result.getStatus().equals((Object)StorageResult.StorageOperationStatus.SUCCESS)) {
                    return new String((byte[])result.getData());
                }
            }
            catch (StorageException e) {
                if (!MAS.DEBUG) break block3;
                Log.w((String)"MAS", (String)"Unable to retrieve last authenticated credentials type from local storage.", (Throwable)e);
            }
        }
        return "";
    }

    public abstract Bitmap getThumbnailImage();

    public abstract void logout(MASCallback<Void> var1);

    public abstract boolean isAuthenticated();

    public abstract boolean isCurrentUser();

    public abstract void requestUserInfo(MASCallback<Void> var1);

    @TargetApi(value=23)
    public abstract void lockSession(MASCallback<Void> var1);

    @TargetApi(value=23)
    public abstract void unlockSession(MASSessionUnlockCallback<Void> var1);

    @TargetApi(value=23)
    public abstract boolean isSessionLocked();

    @TargetApi(value=23)
    public abstract void removeSessionLock(MASCallback<Void> var1);

    @Override
    public abstract void getUserById(String var1, MASCallback<MASUser> var2);

    @Override
    public abstract void getUsersByFilter(MASFilteredRequest var1, MASCallback<List<MASUser>> var2);

    @Override
    public abstract void getUserMetaData(MASCallback<UserAttributes> var1);

    @Override
    public abstract void sendMessage(MASTopic var1, MASMessage var2, MASCallback<Void> var3);

    @Override
    public abstract void sendMessage(MASMessage var1, MASUser var2, MASCallback<Void> var3);

    @Override
    public abstract void sendMessage(MASMessage var1, MASUser var2, String var3, MASCallback<Void> var4);

    @Override
    public abstract void sendMessage(MASMessage var1, MASGroup var2, MASCallback<Void> var3);

    @Override
    public abstract void sendMessage(MASMessage var1, MASGroup var2, String var3, MASCallback<Void> var4);

    @Override
    public abstract void startListeningToMyMessages(MASCallback<Void> var1);

    @Override
    public abstract void stopListeningToMyMessages(MASCallback<Void> var1);

    static {
        EventDispatcher.STOP.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                current = null;
            }
        });
    }
}

