/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.foundation.MASClaims;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASUser;
import com.nimbusds.jwt.util.DateUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MASClaimsBuilder {
    private Map<String, Object> claims = new HashMap<String, Object>();

    public MASClaimsBuilder() {
    }

    public MASClaimsBuilder(MASClaims masClaims) {
        if (masClaims != null) {
            this.claims.putAll(masClaims.getClaims());
        }
    }

    public MASClaimsBuilder issuer(String issuer) {
        this.claims.put("iss", issuer);
        return this;
    }

    public MASClaimsBuilder subject(String subject) {
        this.claims.put("sub", subject);
        return this;
    }

    public MASClaimsBuilder audience(String aud) {
        if (aud != null) {
            this.claims.put("aud", Collections.singletonList(aud));
        }
        return this;
    }

    public MASClaimsBuilder audience(List<String> audList) {
        if (audList != null) {
            this.claims.put("aud", audList);
        }
        return this;
    }

    public MASClaimsBuilder expirationTime(Date exp) {
        this.claims.put("exp", exp);
        return this;
    }

    public MASClaimsBuilder notBeforeTime(Date nbf) {
        this.claims.put("nbf", nbf);
        return this;
    }

    public MASClaimsBuilder issueTime(Date iat) {
        this.claims.put("iat", iat);
        return this;
    }

    public MASClaimsBuilder jwtId(String jti) {
        this.claims.put("jti", jti);
        return this;
    }

    public MASClaimsBuilder claim(String name, Object value) {
        this.claims.put(name, value);
        return this;
    }

    public MASClaims build() {
        return new MASClaims(){
            long currentTime = System.currentTimeMillis() / 1000L;

            @Override
            public String getIssuer() {
                if (MASClaimsBuilder.this.claims.containsKey("iss")) {
                    return (String)MASClaimsBuilder.this.claims.get("iss");
                }
                return String.format("device://%s/%s", StorageProvider.getInstance().getTokenManager().getMagIdentifier(), StorageProvider.getInstance().getClientCredentialContainer().getClientId());
            }

            @Override
            public String getSubject() {
                if (MASClaimsBuilder.this.claims.containsKey("sub")) {
                    return (String)MASClaimsBuilder.this.claims.get("sub");
                }
                if (MASUser.getCurrentUser() != null) {
                    return MASUser.getCurrentUser().getUserName();
                }
                return StorageProvider.getInstance().getClientCredentialContainer().getClientId();
            }

            @Override
            public List<String> getAudience() {
                if (MASClaimsBuilder.this.claims.containsKey("aud")) {
                    return (List)MASClaimsBuilder.this.claims.get("aud");
                }
                return Collections.singletonList(MASConfiguration.getCurrentConfiguration().getGatewayHostName());
            }

            @Override
            public Date getExpirationTime() {
                if (MASClaimsBuilder.this.claims.containsKey("exp")) {
                    return (Date)MASClaimsBuilder.this.claims.get("exp");
                }
                return DateUtils.fromSecondsSinceEpoch((long)(this.currentTime + 300L));
            }

            @Override
            public Date getNotBefore() {
                if (MASClaimsBuilder.this.claims.containsKey("nbf")) {
                    return (Date)MASClaimsBuilder.this.claims.get("nbf");
                }
                return null;
            }

            @Override
            public Date getIssuedAt() {
                if (MASClaimsBuilder.this.claims.containsKey("iat")) {
                    return (Date)MASClaimsBuilder.this.claims.get("iat");
                }
                return DateUtils.fromSecondsSinceEpoch((long)this.currentTime);
            }

            @Override
            public String getJwtId() {
                if (MASClaimsBuilder.this.claims.containsKey("jti")) {
                    return (String)MASClaimsBuilder.this.claims.get("jti");
                }
                return UUID.randomUUID().toString();
            }

            @Override
            public Map<String, Object> getClaims() {
                return MASClaimsBuilder.this.claims;
            }
        };
    }
}

