/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.util;

import android.content.Context;
import android.os.Build;
import com.ca.mas.core.security.GenerateKeyAttribute;
import com.ca.mas.core.security.KeyStoreException;
import com.ca.mas.core.security.KeyStoreRepository;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.MGF1ParameterSpec;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public class KeyUtilsAsymmetric {
    private static final String ANDROID_KEY_STORE = "AndroidKeyStore";
    private static final String CIPHER_ENCRYPTION_ANDROID_PRE_M = "RSA/ECB/PKCS1Padding";
    private static final String CIPHER_ENCRYPTION_ANDROID_M_PLUS = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    private static KeyStoreRepository keyRepository = KeyStoreRepository.getKeyStoreRepository();

    public static PrivateKey generateRsaPrivateKey(Context context, int keysize, String alias, String dn, boolean lollipopEncryptionRequired, boolean marshmallowUserAuthenticationRequired, int marshmallowUserAuthenticationValidityDurationSeconds, boolean nougatInvalidatedByBiometricEnrollment) throws KeyStoreException {
        if (keysize < 2048) {
            keysize = 2048;
        }
        GenerateKeyAttribute attribute = new GenerateKeyAttribute();
        attribute.setKeySize(keysize);
        attribute.setDn(dn);
        attribute.setEncryptionRequired(lollipopEncryptionRequired);
        attribute.setUserAuthenticationRequired(marshmallowUserAuthenticationRequired);
        attribute.setInvalidatedByBiometricEnrollment(nougatInvalidatedByBiometricEnrollment);
        attribute.setUserAuthenticationValidityDurationSeconds(marshmallowUserAuthenticationValidityDurationSeconds);
        return keyRepository.createPrivateKey(alias, attribute).getPrivate();
    }

    public static Key getKeystoreKey(String alias) throws IOException, java.security.KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
        keyStore.load(null);
        return keyStore.getKey(alias, null);
    }

    public static PrivateKey getRsaPrivateKey(String alias) throws KeyStoreException {
        return (PrivateKey)keyRepository.getPrivateKey(alias);
    }

    public static PublicKey getRsaPublicKey(String alias) throws KeyStoreException {
        return (PublicKey)keyRepository.getPublicKey(alias);
    }

    public static void deletePrivateKey(String alias) {
        keyRepository.deleteKey(alias);
    }

    public static void setCertificateChain(String aliasPrefix, X509Certificate[] chain) throws KeyStoreException {
        keyRepository.saveCertificateChain(aliasPrefix, chain);
    }

    public static X509Certificate[] getCertificateChain(String aliasPrefix) throws KeyStoreException {
        return keyRepository.getCertificateChain(aliasPrefix);
    }

    public static void clearCertificateChain(String aliasPrefix) {
        keyRepository.deleteCertificateChain(aliasPrefix);
    }

    public static byte[] encryptSection(PublicKey publicKey, byte[] contentToEncrypt) throws NoSuchPaddingException, InvalidKeyException, InvalidParameterException, BadPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        Cipher cipher = null;
        if (Build.VERSION.SDK_INT < 23) {
            cipher = Cipher.getInstance(CIPHER_ENCRYPTION_ANDROID_PRE_M);
            cipher.init(1, publicKey);
        } else {
            cipher = Cipher.getInstance(CIPHER_ENCRYPTION_ANDROID_M_PLUS);
            cipher.init(1, (Key)publicKey, new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT));
        }
        byte[] encryptedBytes = cipher.doFinal(contentToEncrypt);
        return encryptedBytes;
    }

    public static byte[] decryptSection(PrivateKey privateKey, byte[] contentToDecrypt) throws NoSuchPaddingException, InvalidKeyException, BadPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, IllegalArgumentException, InvalidAlgorithmParameterException {
        Cipher cipher;
        if (Build.VERSION.SDK_INT < 23) {
            cipher = Cipher.getInstance(CIPHER_ENCRYPTION_ANDROID_PRE_M);
            cipher.init(2, privateKey);
        } else {
            cipher = Cipher.getInstance(CIPHER_ENCRYPTION_ANDROID_M_PLUS);
            cipher.init(2, (Key)privateKey, new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT));
        }
        byte[] decryptedBytes = cipher.doFinal(contentToDecrypt);
        return decryptedBytes;
    }

    public static byte[] decrypt(PrivateKey privateKey, int keysize, byte[] contentToDecrypt) throws NoSuchPaddingException, InvalidKeyException, InvalidParameterException, BadPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        int encryptedSize = 256;
        ArrayList<byte[]> encryptedParts = KeyUtilsAsymmetric.arraySplit(contentToDecrypt, encryptedSize);
        ArrayList<byte[]> decrypted = new ArrayList<byte[]>();
        for (byte[] bytesToDecrypt : encryptedParts) {
            byte[] decryptedBytes = KeyUtilsAsymmetric.decryptSection(privateKey, bytesToDecrypt);
            decrypted.add(decryptedBytes);
        }
        byte[] bytesDecrypted = KeyUtilsAsymmetric.arrayConcat(decrypted);
        return bytesDecrypted;
    }

    public static byte[] encrypt(PublicKey publicKey, int keysize, byte[] contentToEncrypt) throws NoSuchPaddingException, InvalidKeyException, BadPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        int originalChunk = 128;
        ArrayList<byte[]> original = KeyUtilsAsymmetric.arraySplit(contentToEncrypt, originalChunk);
        ArrayList<byte[]> encrypted = new ArrayList<byte[]>();
        for (byte[] bytesToEncrypt : original) {
            byte[] encryptedBytes = KeyUtilsAsymmetric.encryptSection(publicKey, bytesToEncrypt);
            encrypted.add(encryptedBytes);
        }
        byte[] bytesEncryptedFull = KeyUtilsAsymmetric.arrayConcat(encrypted);
        return bytesEncryptedFull;
    }

    private static byte[] arrayConcat(ArrayList<byte[]> byteArrayList) {
        int lengthTotal = 0;
        for (byte[] byteArray : byteArrayList) {
            lengthTotal += byteArray.length;
        }
        byte[] result = new byte[lengthTotal];
        int lengthCurrent = 0;
        for (byte[] byteArray : byteArrayList) {
            System.arraycopy(byteArray, 0, result, lengthCurrent, byteArray.length);
            lengthCurrent += byteArray.length;
        }
        return result;
    }

    private static ArrayList<byte[]> arraySplit(byte[] bytes, int eachLength) {
        int lengthCurrent;
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int lengthTotal = 0; lengthTotal < bytes.length; lengthTotal += lengthCurrent) {
            lengthCurrent = bytes.length - lengthTotal;
            if (lengthCurrent > eachLength) {
                lengthCurrent = eachLength;
            }
            byte[] section = new byte[lengthCurrent];
            System.arraycopy(bytes, lengthTotal, section, 0, lengthCurrent);
            result.add(section);
        }
        return result;
    }

    protected KeyUtilsAsymmetric() {
    }
}

