/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.service;

import android.os.Bundle;
import com.ca.mas.core.service.MssoResponse;
import com.ca.mas.core.util.Functions;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class MssoResponseQueue {
    private static final MssoResponseQueue INSTANCE = new MssoResponseQueue();
    private final Map<Long, MssoResponse> outboundResponses = new LinkedHashMap<Long, MssoResponse>();

    private MssoResponseQueue() {
    }

    public static MssoResponseQueue getInstance() {
        return INSTANCE;
    }

    synchronized void addResponse(MssoResponse response) {
        this.outboundResponses.put(response.getId(), response);
    }

    synchronized MssoResponse takeResponse(long responseId) {
        return this.outboundResponses.remove(responseId);
    }

    synchronized void removeMatching(Functions.Unary<Boolean, MssoResponse> predicate, Bundle data) {
        Iterator<MssoResponse> it = this.outboundResponses.values().iterator();
        while (it.hasNext()) {
            MssoResponse mssoResponse = it.next();
            if (predicate.call(mssoResponse).booleanValue() && mssoResponse.getRequest().getResultReceiver() != null) {
                mssoResponse.getRequest().getResultReceiver().send(4, data);
            }
            it.remove();
        }
    }
}

