/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.core.security.EncryptionProvider;
import com.ca.mas.core.util.KeyUtilsAsymmetric;
import com.ca.mas.core.util.KeyUtilsSymmetric;
import com.ca.mas.foundation.MAS;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;

public class LockableEncryptionProvider
implements EncryptionProvider {
    protected Context ctx = null;
    private String keyAlias = "com.ca.mas.LOCKABLE_KEY";
    private static final int KEY_SIZE = 2048;

    public LockableEncryptionProvider(@NonNull Context ctx) {
        this.ctx = ctx;
    }

    public LockableEncryptionProvider(@NonNull Context ctx, @NonNull String keyAlias) {
        this.ctx = ctx;
        this.keyAlias = keyAlias;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        try {
            PublicKey pubkey = KeyUtilsAsymmetric.getRsaPublicKey(this.keyAlias);
            if (pubkey == null) {
                KeyUtilsAsymmetric.generateRsaPrivateKey(this.ctx, 2048, this.keyAlias, "cn=" + this.keyAlias, true, true, 4, false);
                pubkey = KeyUtilsAsymmetric.getRsaPublicKey(this.keyAlias);
            }
            return KeyUtilsAsymmetric.encrypt(pubkey, 2048, data);
        }
        catch (Exception x) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Unable to encrypt given data");
            }
            throw new RuntimeException(x);
        }
    }

    @Override
    public byte[] decrypt(byte[] encryptedData) {
        try {
            Key keyStoreKey = KeyUtilsAsymmetric.getKeystoreKey(this.keyAlias);
            if (keyStoreKey instanceof PrivateKey) {
                PrivateKey privkey = KeyUtilsAsymmetric.getRsaPrivateKey(this.keyAlias);
                return KeyUtilsAsymmetric.decrypt(privkey, 2048, encryptedData);
            }
            SecretKey secretKey = (SecretKey)keyStoreKey;
            return KeyUtilsSymmetric.decrypt(encryptedData, secretKey, this.keyAlias);
        }
        catch (Exception x) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Unable to decrypt given data.");
            }
            throw new RuntimeException(x);
        }
    }

    public boolean clear() {
        KeyUtilsAsymmetric.deletePrivateKey(this.keyAlias);
        return true;
    }
}

