/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.core.security.KeyStorageProvider;
import com.ca.mas.core.util.KeyUtilsAsymmetric;
import com.ca.mas.core.util.KeyUtilsSymmetric;
import com.ca.mas.foundation.MAS;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class KeyStoreKeyStorageProvider
implements KeyStorageProvider {
    private static final int VALIDITY_SECONDS = 7200;
    protected static final String ASYM_KEY_ALIAS = "ASYM_KEY";
    public static final String RSA_ECB_PKCS1_PADDING = "RSA/ECB/PKCS1PADDING";
    private Context context;

    public KeyStoreKeyStorageProvider(@NonNull Context ctx) {
        this.context = ctx.getApplicationContext();
    }

    @Override
    public SecretKey getKey(String alias, boolean userAuthenticationRequired) {
        SecretKey secretKey = KeyUtilsSymmetric.retrieveKey(alias);
        if (secretKey == null) {
            byte[] encryptedSecretKey = this.getEncryptedSecretKey(alias);
            if (encryptedSecretKey != null) {
                try {
                    secretKey = this.decryptSecretKey(encryptedSecretKey);
                }
                catch (Exception unableToDecrypt) {
                    if (MAS.DEBUG) {
                        Log.e((String)"MAS", (String)"Error while decrypting SecretKey, deleting it", (Throwable)unableToDecrypt);
                    }
                    this.deleteSecretKeyLocally(alias);
                    encryptedSecretKey = null;
                }
            }
            if (secretKey == null) {
                secretKey = userAuthenticationRequired ? KeyUtilsSymmetric.generateKey(alias, "AES", 256, false, true, 7200, false) : KeyUtilsSymmetric.generateKey(alias, "AES", 256, false, false, -1, false);
                if (Build.VERSION.SDK_INT < 23) {
                    encryptedSecretKey = this.encryptSecretKey(secretKey);
                    this.storeSecretKeyLocally(alias, encryptedSecretKey);
                }
            } else if (Build.VERSION.SDK_INT >= 24) {
                KeyUtilsSymmetric.storeKeyAndroidN(alias, secretKey, false, -1, false);
                this.deleteSecretKeyLocally(alias);
            } else if (Build.VERSION.SDK_INT >= 23) {
                KeyUtilsSymmetric.storeKeyAndroidM(alias, secretKey, false, -1);
                this.deleteSecretKeyLocally(alias);
            }
        }
        return secretKey;
    }

    @Override
    public boolean removeKey(String alias) {
        KeyUtilsSymmetric.deleteKey(alias);
        this.deleteSecretKeyLocally(alias);
        return true;
    }

    abstract boolean storeSecretKeyLocally(String var1, byte[] var2);

    abstract byte[] getEncryptedSecretKey(String var1);

    abstract boolean deleteSecretKeyLocally(String var1);

    protected byte[] encryptSecretKey(SecretKey secretKey) {
        try {
            PublicKey publicKey = KeyUtilsAsymmetric.getRsaPublicKey(ASYM_KEY_ALIAS);
            if (publicKey == null) {
                KeyUtilsAsymmetric.generateRsaPrivateKey(this.context, 2048, ASYM_KEY_ALIAS, String.format("CN=%s, OU=%s", ASYM_KEY_ALIAS, "com.ca"), false, false, -1, false);
                publicKey = KeyUtilsAsymmetric.getRsaPublicKey(ASYM_KEY_ALIAS);
            }
            Cipher cipher = Cipher.getInstance(RSA_ECB_PKCS1_PADDING);
            cipher.init(1, publicKey);
            return cipher.doFinal(secretKey.getEncoded());
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error while encrypting SecretKey", (Throwable)e);
            }
            throw new RuntimeException("Error while encrypting SecretKey", e);
        }
    }

    protected SecretKey decryptSecretKey(byte[] encryptedSecretKey) {
        try {
            PrivateKey privateKey = KeyUtilsAsymmetric.getRsaPrivateKey(ASYM_KEY_ALIAS);
            Cipher cipher = Cipher.getInstance(RSA_ECB_PKCS1_PADDING);
            cipher.init(2, privateKey);
            byte[] decryptedSecretkey = cipher.doFinal(encryptedSecretKey);
            return new SecretKeySpec(decryptedSecretkey, "AES");
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error while decrypting SecretKey", (Throwable)e);
            }
            throw new RuntimeException("Error while decrypting SecretKey", e);
        }
    }

    public Context getContext() {
        return this.context;
    }
}

