/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy.exceptions;

import com.ca.mas.core.cert.CertUtils;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.policy.exceptions.RetryRequestException;
import com.ca.mas.core.registration.RegistrationException;
import com.ca.mas.core.store.TokenStoreException;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import java.io.IOException;
import java.net.URI;
import java.security.cert.X509Certificate;

public class CertificateExpiredException
extends RetryRequestException {
    public CertificateExpiredException(String message) {
        super(message);
    }

    public CertificateExpiredException(Throwable throwable) {
        super(throwable);
    }

    @Override
    public void recover(MssoContext context) throws Exception {
        this.renewDevice(context);
    }

    private void renewDevice(MssoContext mssoContext) throws RegistrationException, TokenStoreException {
        MASResponse response;
        URI tokenUri = mssoContext.getConfigurationProvider().getTokenUri("msso.url.renew_device");
        MASRequest.MASRequestBuilder builder = new MASRequest.MASRequestBuilder(tokenUri);
        builder.header("cert-format", "pem");
        builder.put(null);
        MAGHttpClient httpClient = mssoContext.getMAGHttpClient();
        String errorMessage = "Unable to renew device: ";
        try {
            response = httpClient.execute(builder.build());
        }
        catch (IOException e) {
            errorMessage = errorMessage + e.getMessage();
            throw new RegistrationException(120009, errorMessage, e);
        }
        int responseCode = response.getResponseCode();
        if (responseCode != 200) {
            mssoContext.destroyPersistentTokens();
        } else {
            byte[] chainBytes = response.getBody().getRawContent();
            X509Certificate[] chain = CertUtils.decodeCertificateChain(chainBytes);
            mssoContext.getTokenManager().saveClientCertificateChain(chain);
            mssoContext.resetHttpClient();
        }
    }
}

