/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.ca.mas.core.auth.otp.OtpUtil;
import com.ca.mas.core.auth.otp.model.OtpResponseBody;
import com.ca.mas.core.auth.otp.model.OtpResponseHeaders;
import com.ca.mas.core.client.ServerClient;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.exceptions.OtpException;
import com.ca.mas.foundation.MASResponse;

class OtpAssertion
implements MssoAssertion {
    OtpAssertion() {
    }

    @Override
    public void init(@NonNull MssoContext mssoContext, @NonNull Context sysContext) {
    }

    @Override
    public void processRequest(MssoContext mssoContext, RequestInfo request) throws MAGException, MAGServerException {
        Bundle extra = request.getExtra();
        if (extra != null) {
            String selectedChannels;
            String otp = extra.getString("X-OTP");
            if (otp != null) {
                request.getRequest().addHeader("X-OTP", otp);
                extra.remove("X-OTP");
            }
            if ((selectedChannels = extra.getString("X-OTP-CHANNEL")) != null) {
                request.getRequest().addHeader("X-OTP-CHANNEL", selectedChannels);
            }
        }
    }

    @Override
    public void processResponse(MssoContext mssoContext, RequestInfo request, MASResponse response) throws MAGServerException {
        int statusCode = response.getResponseCode();
        if (statusCode == 400 || statusCode == 401 || statusCode == 403) {
            OtpResponseHeaders otpResponseHeaders = OtpUtil.getXotpValueFromHeaders(response.getHeaders());
            otpResponseHeaders.setHttpStatusCode(statusCode);
            if (OtpResponseHeaders.X_OTP_VALUE.REQUIRED == otpResponseHeaders.getxOtpValue() || OtpResponseHeaders.X_CA_ERROR.OTP_INVALID == otpResponseHeaders.getErrorCode()) {
                int errorCode = ServerClient.findErrorCode(response);
                OtpResponseBody body = OtpUtil.parseOtpResponseBody(response.getBody().getContent().toString());
                throw new OtpException(errorCode, statusCode, response.getBody().getContentType(), body.getErrorDescription(), otpResponseHeaders);
            }
        }
    }

    @Override
    public void close() {
    }
}

