/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.exceptions.LocationInvalidException;
import com.ca.mas.core.policy.exceptions.LocationRequiredException;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASResponse;
import java.util.Timer;
import java.util.TimerTask;

class LocationAssertion
implements MssoAssertion {
    static final String DEFAULT_PROVIDER = "network";
    static final long DEFAULT_MIN_TIME = 300000L;
    static final float DEFAULT_MIN_DISTANCE = 100.0f;
    private volatile Location lastLocation;
    private LocationManager locationManager;
    private LocationListener locationListener;
    private Context context;
    private MssoContext mssoContext;

    LocationAssertion() {
    }

    @Override
    public void init(@NonNull MssoContext mssoContext, @NonNull Context sysContext) {
        this.mssoContext = mssoContext;
        this.context = sysContext;
        this.setupLocation();
    }

    private void setupLocation() {
        block7: {
            Float minDistance;
            Long minTime;
            ConfigurationProvider conf = this.mssoContext.getConfigurationProvider();
            if (conf == null) {
                throw new NullPointerException("mssoContext.configurationProvider");
            }
            Boolean enabled = (Boolean)conf.getProperty("msso.location.enabled");
            if (enabled == null || !enabled.booleanValue()) {
                this.close();
                return;
            }
            String locationProvider = (String)conf.getProperty("msso.location.provider.name");
            if (locationProvider == null) {
                locationProvider = DEFAULT_PROVIDER;
            }
            if ((minTime = (Long)conf.getProperty("msso.location.min.time")) == null) {
                minTime = 300000L;
            }
            if ((minDistance = (Float)conf.getProperty("msso.location.min.distance")) == null) {
                minDistance = Float.valueOf(100.0f);
            }
            try {
                this.initLocation(locationProvider, minTime, minDistance.floatValue());
            }
            catch (Exception e) {
                if (!MAS.DEBUG) break block7;
                Log.i((String)"MAS", (String)("No permission to access location: " + e.getMessage()));
            }
        }
    }

    private void initLocation(String locationProvider, long minTime, float minDistance) {
        this.locationManager = (LocationManager)this.context.getSystemService("location");
        this.lastLocation = this.getLastKnownLocation(locationProvider);
        if (this.locationManager != null) {
            this.locationListener = new LocationListener(){

                public void onLocationChanged(Location location) {
                    LocationAssertion.this.lastLocation = location;
                }

                public void onStatusChanged(String provider, int status, Bundle extras) {
                }

                public void onProviderEnabled(final String provider) {
                    LocationAssertion.this.lastLocation = LocationAssertion.this.getLastKnownLocation(provider);
                    if (LocationAssertion.this.lastLocation == null) {
                        final Timer timer = new Timer();
                        timer.schedule(new TimerTask(){
                            private int count = 0;

                            @Override
                            public void run() {
                                LocationAssertion.this.lastLocation = LocationAssertion.this.getLastKnownLocation(provider);
                                ++this.count;
                                if (LocationAssertion.this.lastLocation != null || this.count >= 5) {
                                    timer.cancel();
                                }
                            }
                        }, 3000L, 1000L);
                    }
                }

                public void onProviderDisabled(String provider) {
                    LocationAssertion.this.lastLocation = null;
                }
            };
            this.locationManager.requestLocationUpdates(locationProvider, minTime, minDistance, this.locationListener);
        }
    }

    private Location getLastKnownLocation(String locationProvider) {
        block3: {
            if (this.locationManager != null) {
                try {
                    return this.locationManager.getLastKnownLocation(locationProvider);
                }
                catch (SecurityException e) {
                    if (!MAS.DEBUG) break block3;
                    Log.d((String)"MAS", (String)("No permission to access location: " + e.getMessage()));
                }
            }
        }
        return null;
    }

    @Override
    public void processResponse(MssoContext mssoContext, RequestInfo request, MASResponse response) throws MAGException {
        String responseContent;
        int statusCode = response.getResponseCode();
        if (statusCode >= 400 && statusCode < 500 && (responseContent = new String(response.getBody().getRawContent())).toLowerCase().contains("location")) {
            if (statusCode == 449) {
                throw new LocationRequiredException("This application requires your location information. Please enable location services to continue.");
            }
            if (statusCode == 448) {
                throw new LocationInvalidException("This location is unauthorized.");
            }
        }
    }

    @Override
    public void close() {
        if (this.locationListener != null && this.locationManager != null) {
            block3: {
                try {
                    this.locationManager.removeUpdates(this.locationListener);
                }
                catch (SecurityException e) {
                    if (!MAS.DEBUG) break block3;
                    Log.i((String)"MAS", (String)("Unable to access location " + e.getMessage()));
                }
            }
            this.locationManager = null;
            this.locationListener = null;
            this.lastLocation = null;
        }
    }

    private Location getLastLocation() {
        if (this.lastLocation != null) {
            return this.lastLocation;
        }
        this.setupLocation();
        return this.lastLocation;
    }

    @Override
    public void processRequest(MssoContext mssoContext, RequestInfo request) {
        if (this.getLastLocation() != null) {
            String loc = String.format("%f,%f", this.getLastLocation().getLatitude(), this.getLastLocation().getLongitude());
            request.getRequest().addHeader("geo-location", loc);
        }
    }
}

