/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.context.MssoException;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.error.MAGStateException;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.exceptions.CertificateExpiredException;
import com.ca.mas.core.policy.exceptions.CredentialRequiredException;
import com.ca.mas.core.policy.exceptions.RetryRequestException;
import com.ca.mas.core.policy.exceptions.TokenStoreUnavailableException;
import com.ca.mas.core.registration.DeviceRegistrationAwaitingActivationException;
import com.ca.mas.core.registration.RegistrationClient;
import com.ca.mas.core.registration.RegistrationException;
import com.ca.mas.core.security.KeyStoreException;
import com.ca.mas.core.security.KeyStoreRepository;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASResponse;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;

class DeviceRegistrationAssertion
implements MssoAssertion {
    private TokenManager tokenManager;
    private Context ctx = null;

    DeviceRegistrationAssertion() {
    }

    @Override
    public void init(@NonNull MssoContext mssoContext, @NonNull Context sysContext) {
        this.tokenManager = mssoContext.getTokenManager();
        this.ctx = sysContext;
        if (this.tokenManager == null) {
            throw new NullPointerException("mssoContext.tokenManager");
        }
        if (mssoContext.getConfigurationProvider() == null) {
            throw new NullPointerException("mssoContext.configurationProvider");
        }
    }

    @Override
    public synchronized void processRequest(MssoContext mssoContext, RequestInfo request) throws MAGException, MAGServerException {
        boolean ssoEnabled;
        X509Certificate[] clientCerts = this.tokenManager.getClientCertificateChain();
        if (clientCerts != null && clientCerts.length > 0) {
            X509Certificate certificate = clientCerts[0];
            try {
                Calendar cal = Calendar.getInstance();
                cal.add(6, ConfigurationManager.getInstance().getCertificateAdvancedRenewTimeframe());
                Date date = cal.getTime();
                certificate.checkValidity(date);
            }
            catch (java.security.cert.CertificateExpiredException e) {
                throw new CertificateExpiredException(e);
            }
            catch (CertificateNotYetValidException e) {
                // empty catch block
            }
            if (this.tokenManager.getMagIdentifier() != null) {
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)String.format("Device is registered with identifier: %s", this.tokenManager.getMagIdentifier()));
                }
                return;
            }
        }
        boolean clearCredentials = true;
        try {
            this.registerDevice(mssoContext, request);
        }
        catch (RetryRequestException e) {
            try {
                clearCredentials = false;
                throw e;
            }
            catch (Throwable throwable) {
                boolean ssoEnabled2;
                Boolean ssoEnabledProp = (Boolean)mssoContext.getConfigurationProvider().getProperty("msso.sso.enabled");
                boolean bl = ssoEnabled2 = ssoEnabledProp != null && ssoEnabledProp != false;
                if (ssoEnabled2 && (clearCredentials || mssoContext.getCredentials() != null && !mssoContext.getCredentials().isReusable())) {
                    mssoContext.clearCredentials();
                }
                throw throwable;
            }
        }
        Boolean ssoEnabledProp = (Boolean)mssoContext.getConfigurationProvider().getProperty("msso.sso.enabled");
        boolean bl = ssoEnabled = ssoEnabledProp != null && ssoEnabledProp != false;
        if (ssoEnabled && (clearCredentials || mssoContext.getCredentials() != null && !mssoContext.getCredentials().isReusable())) {
            mssoContext.clearCredentials();
        }
    }

    @Override
    public void processResponse(MssoContext mssoContext, RequestInfo request, MASResponse response) throws MAGStateException {
    }

    private void registerDevice(MssoContext mssoContext, RequestInfo request) throws MAGException, MAGServerException {
        byte[] csrBytes;
        String deviceId;
        PrivateKey privateKey;
        MASAuthCredentials creds = request.getRequest().getGrantProvider().getCredentials(mssoContext);
        if (creds == null || !creds.isValid()) {
            throw new CredentialRequiredException();
        }
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)"Device registration process start");
        }
        if ((privateKey = this.tokenManager.getClientPrivateKey()) == null) {
            Integer keyBits = (Integer)mssoContext.getConfigurationProvider().getProperty("msso.cert.rsa.keybits");
            if (keyBits == null) {
                keyBits = 2048;
            }
            try {
                privateKey = this.tokenManager.createPrivateKey(this.ctx, keyBits);
            }
            catch (KeyStoreException e) {
                throw new RegistrationException(120004, "Failed to generate private key.", e);
            }
        }
        PublicKey publicKey = this.tokenManager.getClientPublicKey();
        String deviceName = mssoContext.getDeviceName();
        try {
            deviceId = mssoContext.getDeviceId();
            String organization = (String)mssoContext.getConfigurationProvider().getProperty("msso.organization");
            csrBytes = KeyStoreRepository.getKeyStoreRepository().generateCertificateSigningRequest(creds.getUsername(), deviceId, deviceName, organization, privateKey, publicKey);
        }
        catch (CertificateException e) {
            throw new RegistrationException(120004, (Throwable)e);
        }
        catch (Exception e) {
            throw new MssoException(e);
        }
        mssoContext.resetHttpClient();
        Boolean ssoEnabled = (Boolean)mssoContext.getConfigurationProvider().getProperty("msso.sso.enabled");
        boolean createSession = ssoEnabled != null && ssoEnabled != false;
        String clientId = mssoContext.getClientId();
        String clientSecret = mssoContext.getClientSecret();
        RegistrationClient.DeviceRegistrationResult result = new RegistrationClient(mssoContext).registerDevice(csrBytes, request.getRequest(), clientId, clientSecret, deviceId, deviceName, createSession);
        IdToken idToken = result.getIdToken();
        try {
            this.tokenManager.saveClientCertificateChain(result.getClientCertificateChain());
            this.tokenManager.saveMagIdentifier(result.getMagIdentifier());
        }
        catch (Exception e) {
            throw new TokenStoreUnavailableException(e);
        }
        mssoContext.onDeviceRegistrationCompleted();
        if (idToken != null) {
            mssoContext.onIdTokenAvailable(idToken);
        }
        if (RegistrationClient.DeviceStatus.REGISTERED.equals((Object)result.getDeviceStatus())) {
            throw new DeviceRegistrationAwaitingActivationException();
        }
    }

    @Override
    public void close() {
    }
}

