/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.core.client.ServerClient;
import com.ca.mas.core.clientcredentials.ClientCredentialsClient;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.context.MssoException;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.error.MAGStateException;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.exceptions.InvalidClientCredentialException;
import com.ca.mas.core.token.ClientCredentials;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASResponse;
import java.util.UUID;

class ClientCredentialAssertion
implements MssoAssertion {
    public static final String INVALID_CLIENT_CREDENTIALS_ERROR_CODE_SUFFIX = "201";

    ClientCredentialAssertion() {
    }

    @Override
    public void init(@NonNull MssoContext mssoContext, @NonNull Context sysContext) {
        if (mssoContext.getConfigurationProvider() == null) {
            throw new NullPointerException("ConfigurationProvider is null");
        }
    }

    @Override
    public synchronized void processRequest(MssoContext mssoContext, RequestInfo request) throws MAGException, MAGServerException {
        String configuredClientSecret = mssoContext.getConfigurationProvider().getClientSecret();
        String configuredClientId = mssoContext.getConfigurationProvider().getClientId();
        if (configuredClientSecret != null && configuredClientSecret.trim().length() > 0 && !configuredClientId.equals(configuredClientSecret)) {
            if (MAS.DEBUG) {
                Log.d((String)"MAS", (String)"Using static client ID and client secret");
            }
            return;
        }
        if (mssoContext.isClientCredentialExpired(mssoContext.getClientExpiration()) || mssoContext.getStoredClientId() == null) {
            String deviceId;
            try {
                deviceId = mssoContext.getDeviceId();
            }
            catch (Exception e) {
                throw new MssoException(e);
            }
            try {
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)"Retrieving dynamic client credentials");
                }
                String uuid = UUID.randomUUID().toString();
                ClientCredentials result = new ClientCredentialsClient(mssoContext).getClientCredentials(configuredClientId, uuid, deviceId);
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)String.format("Client ID: %s", result.getClientId()));
                }
                mssoContext.setClientCredentials(result);
                return;
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Please check your configurations: one or more configurations are wrong or incomplete");
            }
        }
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)String.format("Client ID: %s", mssoContext.getStoredClientId()));
        }
    }

    @Override
    public void processResponse(MssoContext mssoContext, RequestInfo request, MASResponse response) throws MAGStateException {
        int errorCode = ServerClient.findErrorCode(response);
        if (errorCode == -1) {
            return;
        }
        String s = Integer.toString(errorCode);
        if (s.endsWith(INVALID_CLIENT_CREDENTIALS_ERROR_CODE_SUFFIX)) {
            throw new InvalidClientCredentialException("Client is rejected by server");
        }
    }

    @Override
    public void close() {
    }
}

