/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.oauth;

import android.util.Base64;
import android.util.Log;
import com.ca.mas.core.oauth.PKCE;
import com.ca.mas.foundation.MAS;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class OAuthClientUtil {
    private OAuthClientUtil() {
    }

    public static PKCE generateCodeChallenge() {
        int encodeFlags = 11;
        byte[] randomBytes = new byte[64];
        new SecureRandom().nextBytes(randomBytes);
        String codeVerifier = Base64.encodeToString((byte[])randomBytes, (int)encodeFlags);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(codeVerifier.getBytes("ISO_8859_1"));
            byte[] digestBytes = messageDigest.digest();
            return new PKCE("S256", Base64.encodeToString((byte[])digestBytes, (int)encodeFlags), codeVerifier);
        }
        catch (NoSuchAlgorithmException e) {
            if (MAS.DEBUG) {
                Log.w((String)"SHA-256 not supported", (Throwable)e);
            }
            return new PKCE("plain", codeVerifier, codeVerifier);
        }
        catch (UnsupportedEncodingException e) {
            if (MAS.DEBUG) {
                Log.e((String)"PKCE not supported", (String)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }
}

