/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.io.http;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class SingleKeyX509KeyManager
extends X509ExtendedKeyManager {
    private final X509Certificate[] certChain;
    private final PrivateKey privateKey;
    private final String alias;

    public SingleKeyX509KeyManager(PrivateKey privateKey, X509Certificate[] certChain) {
        if (certChain == null) {
            throw new NullPointerException("certChain");
        }
        if (certChain.length < 1) {
            throw new IllegalArgumentException("certChain is empty");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey");
        }
        this.certChain = certChain;
        this.privateKey = privateKey;
        this.alias = "clientCert";
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return new String[]{this.alias};
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.alias;
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return new String[]{this.alias};
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.alias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.alias.equals(s) ? this.certChain : null;
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.alias.equals(s) ? this.privateKey : null;
    }

    @Override
    public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
        return this.alias;
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principals, SSLEngine sslEngine) {
        return this.alias;
    }
}

