/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.io;

import android.util.Base64;
import android.util.Log;
import com.ca.mas.foundation.MAS;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class IoUtils {
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] hexadecimal_upper = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] slurpStream(InputStream stream, int limit) throws IOException {
        int got;
        byte[] buf = new byte[4096];
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        int total = 0;
        while ((got = stream.read(buf)) > 0) {
            out.write(buf, 0, got);
            if ((total += got) < limit) continue;
            throw new IOException("Stream length limit exceeded; limit=" + limit);
        }
        return out.toByteArray();
    }

    public static String hexDump(byte[] binaryData) {
        return IoUtils.hexDump(binaryData, 0, binaryData.length);
    }

    public static String hexDump(byte[] binaryData, int off, int len) {
        return IoUtils.hexDump(binaryData, off, len, false);
    }

    public static String hexDump(byte[] binaryData, int off, int len, boolean upperCase) {
        char[] hex;
        char[] cArray = hex = upperCase ? hexadecimal_upper : hexadecimal;
        if (binaryData == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > binaryData.length) {
            throw new IllegalArgumentException();
        }
        char[] buffer = new char[len * 2];
        for (int i = 0; i < len; ++i) {
            int low = binaryData[off + i] & 0xF;
            int high = (binaryData[off + i] & 0xF0) >> 4;
            buffer[i * 2] = hex[high];
            buffer[i * 2 + 1] = hex[low];
        }
        return new String(buffer);
    }

    public static byte[] hexToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String base64(String str, Charset charset) {
        return Base64.encodeToString((byte[])str.getBytes(charset), (int)2);
    }

    public static void closeQuietly(Closeable closeable) {
        block5: {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (IOException e) {
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)("Exception closing closeable: " + e.getMessage()), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!MAS.DEBUG) break block5;
                Log.e((String)"MAS", (String)("Error closing closeable: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private IoUtils() {
    }
}

