/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.datasource;

import android.content.Context;
import android.content.Intent;
import com.ca.mas.core.datasource.DataConverter;
import com.ca.mas.core.datasource.DataSource;
import com.ca.mas.core.datasource.DataSourceCallback;
import com.ca.mas.core.datasource.DataSourceError;
import com.ca.mas.core.datasource.DataSourceException;
import com.ca.mas.core.storage.StorageException;
import com.ca.mas.core.storage.StorageResult;
import com.ca.mas.core.storage.StorageResultReceiver;
import com.ca.mas.core.storage.implementation.KeyStoreStorage;
import com.ca.mas.core.storage.implementation.MASStorageManager;
import java.util.List;
import org.json.JSONObject;

public class KeystoreDataSource<K, V>
implements DataSource<K, V> {
    public static final String SHARE = "share";
    private KeyStoreStorage storage;
    private DataConverter converter;
    private Context context;
    private boolean isShared;

    public KeystoreDataSource(Context context, JSONObject param, DataConverter converter) {
        block3: {
            this.converter = converter;
            this.context = context;
            try {
                if (param != null) {
                    this.isShared = param.optBoolean(SHARE, false);
                }
                this.storage = (KeyStoreStorage)new MASStorageManager().getStorage(KeyStoreStorage.class, (Object)new Object[]{context, this.isShared});
            }
            catch (StorageException e) {
                if (e.getCode() == 153) break block3;
                throw new DataSourceException(e);
            }
        }
    }

    @Override
    public void put(K key, V value) {
        try {
            StorageResult result = null;
            if (value instanceof byte[]) {
                result = this.storage.writeOrUpdateData((String)key, (byte[])value);
            } else if (value instanceof String) {
                result = this.storage.writeOrUpdateString((String)key, (String)value);
            } else {
                if (value == null) {
                    this.remove(key);
                    return;
                }
                throw new UnsupportedOperationException("Value type not supported");
            }
            if (result.getStatus() == StorageResult.StorageOperationStatus.FAILURE) {
                throw (StorageException)result.getData();
            }
        }
        catch (StorageException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public void put(K key, V value, final DataSourceCallback callback) {
        block4: {
            try {
                if (value instanceof byte[]) {
                    this.storage.writeOrUpdateData((String)key, (byte[])value, new StorageResultReceiver(callback.getHandler()){

                        @Override
                        public void onReceiveResult(StorageResult result) {
                            if (result.getStatus() == StorageResult.StorageOperationStatus.FAILURE) {
                                callback.onError(new DataSourceError((StorageException)result.getData()));
                            } else {
                                callback.onSuccess(null);
                            }
                        }
                    });
                    break block4;
                }
                if (value instanceof String) {
                    this.storage.writeOrUpdateString((String)key, (String)value, new StorageResultReceiver(callback.getHandler()){

                        @Override
                        public void onReceiveResult(StorageResult result) {
                            if (result.getStatus() == StorageResult.StorageOperationStatus.FAILURE) {
                                callback.onError(new DataSourceError((StorageException)result.getData()));
                            } else {
                                callback.onSuccess(null);
                            }
                        }
                    });
                    break block4;
                }
                throw new UnsupportedOperationException("Value type not supported");
            }
            catch (StorageException e) {
                throw new DataSourceException(e);
            }
        }
    }

    @Override
    public V get(K key) {
        try {
            StorageResult result = null;
            result = this.storage.readData((String)key);
            if (result.getStatus() == StorageResult.StorageOperationStatus.FAILURE) {
                StorageException exception = (StorageException)result.getData();
                if (exception.getCode() == 105) {
                    return null;
                }
                throw exception;
            }
            if (this.converter != null) {
                return this.converter.convert(key, (byte[])result.getData());
            }
            return (V)result.getData();
        }
        catch (StorageException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public void get(final K key, final DataSourceCallback callback) {
        try {
            this.storage.readData((String)key, new StorageResultReceiver(callback.getHandler()){

                @Override
                public void onReceiveResult(StorageResult result) {
                    if (result.getStatus() == StorageResult.StorageOperationStatus.FAILURE) {
                        callback.onError(new DataSourceError((StorageException)result.getData()));
                    } else if (KeystoreDataSource.this.converter != null) {
                        callback.onSuccess(KeystoreDataSource.this.converter.convert(key, (byte[])result.getData()));
                    } else {
                        callback.onSuccess(result.getData());
                    }
                }
            });
        }
        catch (StorageException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public void remove(K key) {
        try {
            StorageResult result = this.storage.deleteData((String)key);
            if (result.getStatus() == StorageResult.StorageOperationStatus.FAILURE && ((StorageException)result.getData()).getCode() != 105) {
                throw (StorageException)result.getData();
            }
        }
        catch (StorageException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public void remove(K key, final DataSourceCallback callback) {
        try {
            this.storage.deleteData((String)key, new StorageResultReceiver(callback.getHandler()){

                @Override
                public void onReceiveResult(StorageResult result) {
                    if (result.getStatus() == StorageResult.StorageOperationStatus.FAILURE) {
                        callback.onError(new DataSourceError((StorageException)result.getData()));
                    } else {
                        callback.onSuccess(null);
                    }
                }
            });
        }
        catch (StorageException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public void removeAll(Object filter) {
        try {
            StorageResult result = this.storage.deleteAll();
            if (result.getStatus() == StorageResult.StorageOperationStatus.FAILURE && ((StorageException)result.getData()).getCode() != 105) {
                throw (StorageException)result.getData();
            }
        }
        catch (StorageException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public void removeAll(Object filter, final DataSourceCallback callback) {
        try {
            this.storage.deleteAll(new StorageResultReceiver(callback.getHandler()){

                @Override
                public void onReceiveResult(StorageResult result) {
                    if (result.getStatus() == StorageResult.StorageOperationStatus.FAILURE) {
                        callback.onError(new DataSourceError((StorageException)result.getData()));
                    } else {
                        callback.onSuccess(null);
                    }
                }
            });
        }
        catch (StorageException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public List<K> getKeys(Object filter) {
        StorageResult result = this.storage.getAllKeys();
        if (result.getStatus() == StorageResult.StorageOperationStatus.SUCCESS) {
            return (List)result.getData();
        }
        throw new DataSourceException((Throwable)result.getData());
    }

    @Override
    public void getKeys(Object filter, final DataSourceCallback callback) {
        try {
            this.storage.getAllKeys(new StorageResultReceiver(callback.getHandler()){

                @Override
                public void onReceiveResult(StorageResult result) {
                    if (result.getStatus() == StorageResult.StorageOperationStatus.FAILURE) {
                        callback.onError(new DataSourceError((StorageException)result.getData()));
                    } else {
                        callback.onSuccess(result.getData());
                    }
                }
            });
        }
        catch (StorageException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public boolean isReady() {
        if (this.storage == null) {
            try {
                this.storage = (KeyStoreStorage)new MASStorageManager().getStorage(KeyStoreStorage.class, (Object)new Object[]{this.context, this.isShared});
            }
            catch (StorageException e) {
                if (e.getCode() == 153) {
                    return false;
                }
                throw new DataSourceException(e);
            }
        }
        StorageResult result = null;
        try {
            result = this.storage.readString(KeystoreDataSource.class.getCanonicalName());
            if (result.getStatus() != StorageResult.StorageOperationStatus.SUCCESS) {
                return ((StorageException)result.getData()).getCode() != 153;
            }
            throw new IllegalStateException("Should has no value in storage.");
        }
        catch (StorageException e) {
            throw new DataSourceException(e);
        }
    }

    @Override
    public void unlock() {
        try {
            Intent intent = new Intent("com.android.credentials.UNLOCK");
            intent.setFlags(0x10000000);
            this.context.startActivity(intent);
        }
        catch (Exception e) {
            throw new DataSourceException("Error unlocking KeyStore storage", e);
        }
    }
}

