/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.auth;

import android.content.Context;
import android.util.Log;
import android.webkit.URLUtil;
import com.ca.mas.core.auth.AuthRenderer;
import com.ca.mas.core.service.Provider;
import com.ca.mas.foundation.MAS;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class PollingRenderer
extends AuthRenderer {
    public static final int INVALID_SESSION_ID_OR_POLL_URL = 10;
    public static final int SESSION_EXPIRED = 11;
    public static final int POLL_INTERVAL = 5;
    public static final int MAX_POLL_COUNT = 6;
    public static final int DELAY = 10;
    private TimerTask task;
    private ScheduledExecutorService timer = null;

    @Override
    public boolean init(Context context, Provider provider) {
        if (!super.init(context, provider)) {
            return false;
        }
        if (provider.getPollUrl() == null || !URLUtil.isHttpsUrl((String)provider.getPollUrl())) {
            this.onError(10, "Invalid Poll url", null);
            return false;
        }
        if (provider.getUrl() == null || !URLUtil.isHttpsUrl((String)provider.getUrl())) {
            this.onError(10, "Invalid session id", null);
            return false;
        }
        return true;
    }

    @Override
    public void onRenderCompleted() {
        if (this.startPollingOnStartup()) {
            this.poll();
        }
    }

    @Override
    public void close() {
        if (this.timer != null && !this.timer.isShutdown()) {
            this.timer.shutdown();
        }
    }

    protected void poll() {
        if (this.timer != null && !this.timer.isShutdown()) {
            this.timer.shutdown();
        }
        this.timer = Executors.newScheduledThreadPool(1);
        final long maxPollCount = this.getMaxPollCount();
        final int[] pollCount = new int[]{0};
        this.task = new TimerTask(){

            @Override
            public void run() {
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)"Polling Authorization code from Server");
                }
                int n = pollCount[0];
                pollCount[0] = n + 1;
                if ((long)n < maxPollCount) {
                    PollingRenderer.this.proceed();
                } else {
                    PollingRenderer.this.onError(11, "Session expired", null);
                    PollingRenderer.this.close();
                }
            }
        };
        this.timer.scheduleWithFixedDelay(this.task, this.getDelay(), this.getPollInterval(), TimeUnit.SECONDS);
    }

    protected long getPollInterval() {
        return 5L;
    }

    protected long getMaxPollCount() {
        return 6L;
    }

    protected long getDelay() {
        return 10L;
    }

    @Override
    protected void onAuthCodeReceived(String code) {
        if (this.timer != null) {
            this.timer.shutdown();
        }
    }

    protected abstract boolean startPollingOnStartup();
}

