/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.auth;

import android.content.Context;
import android.view.View;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.service.Provider;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.foundation.MASAuthCredentialsAuthorizationCode;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASResponseBody;
import com.ca.mas.foundation.MASUser;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public abstract class AuthRenderer {
    public static final int AUTH_CODE_ERR = 1;
    protected Context context;
    protected Provider provider;
    protected long requestId;

    public boolean init(Context context, Provider provider) {
        this.context = context;
        this.provider = provider;
        return true;
    }

    public String getId() {
        return "qrcode";
    }

    public abstract View render();

    public abstract void onRenderCompleted();

    protected abstract void onError(int var1, String var2, Exception var3);

    public abstract void close();

    protected synchronized void proceed() {
        try {
            MASRequest request = new MASRequest.MASRequestBuilder(new URL(this.provider.getPollUrl())).responseBody(MASResponseBody.jsonBody()).build();
            MAGHttpClient httpClient = new MAGHttpClient(){

                @Override
                protected void onConnectionObtained(HttpURLConnection connection) {
                    super.onConnectionObtained(connection);
                    TokenManager tokenManager = StorageProvider.getInstance().getTokenManager();
                    String magIdentifier = tokenManager.getMagIdentifier();
                    if (magIdentifier != null) {
                        connection.setRequestProperty("mag-identifier", magIdentifier);
                    }
                }
            };
            MASResponse response = httpClient.execute(request);
            if (200 == response.getResponseCode()) {
                JSONObject json;
                if (response.getBody() != null && (json = (JSONObject)response.getBody().getContent()) != null) {
                    String code = json.getString("code");
                    String state = json.optString("state");
                    if (code != null && code.length() > 0) {
                        MASUser.login(new MASAuthCredentialsAuthorizationCode(code, state), null);
                        this.onAuthCodeReceived(code);
                    }
                }
            } else {
                String msg = "Session Polling error.";
                if (response.getBody() != null) {
                    msg = new String(response.getBody().getRawContent());
                }
                this.onError(1, msg, null);
            }
        }
        catch (Exception e) {
            this.onError(1, e.getMessage(), e);
        }
    }

    protected abstract void onAuthCodeReceived(String var1);
}

