/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core;

import android.content.Context;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.support.annotation.NonNull;
import com.ca.mas.core.EventDispatcher;
import com.ca.mas.core.MAGResultReceiver;
import com.ca.mas.core.MobileSso;
import com.ca.mas.core.auth.AuthResultReceiver;
import com.ca.mas.core.auth.ble.BluetoothLePeripheral;
import com.ca.mas.core.auth.ble.BluetoothLePeripheralCallback;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.core.conf.Server;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.error.MAGRuntimeException;
import com.ca.mas.core.oauth.OAuthClient;
import com.ca.mas.core.service.AuthenticationProvider;
import com.ca.mas.core.service.MssoClient;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public final class MobileSsoFactory {
    private static final AtomicReference<MobileSso> mobileSso = new AtomicReference();

    private MobileSsoFactory() {
    }

    public static MobileSso getInstance() {
        MobileSso ret = mobileSso.get();
        if (ret != null) {
            return ret;
        }
        throw new IllegalStateException("MAS SDK has not been initialized.");
    }

    public static MobileSso getInstance(@NonNull Context context, boolean forceDefault) {
        ConfigurationManager.getInstance().init(context);
        if (forceDefault) {
            ConfigurationManager.getInstance().activateDefault();
        } else {
            MobileSso ret = mobileSso.get();
            if (ret != null) {
                return ret;
            }
        }
        return MobileSsoFactory.getInstance(context, ConfigurationManager.getInstance().getConnectedGatewayConfig());
    }

    public static MobileSso getInstance(@NonNull Context context) {
        return MobileSsoFactory.getInstance(context, false);
    }

    public static MobileSso getInstance(@NonNull Context context, @NonNull URL url) {
        if (!"file".equalsIgnoreCase(url.getProtocol())) {
            throw new MAGRuntimeException(100001, "Invalid URL, only file URL is allowed");
        }
        ConfigurationManager.getInstance().init(context);
        InputStream is = null;
        try {
            is = url.openStream();
            JSONObject jsonObject = ConfigurationManager.getInstance().getConfig(is);
            MobileSso mobileSso = MobileSsoFactory.getInstance(context, jsonObject);
            return mobileSso;
        }
        catch (IOException e) {
            throw new MAGRuntimeException(100002, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MobileSso getInstance(@NonNull Context context, @NonNull JSONObject config) {
        AtomicReference<MobileSso> atomicReference = mobileSso;
        synchronized (atomicReference) {
            ConfigurationManager.getInstance().init(context);
            boolean isSwitching = false;
            if (MobileSsoFactory.isSwitchGateway(config)) {
                EventDispatcher.BEFORE_GATEWAY_SWITCH.notifyObservers();
                isSwitching = true;
            }
            ConfigurationManager.getInstance().activate(config);
            mobileSso.set(MobileSsoFactory.createMobileSso(context));
            if (isSwitching) {
                EventDispatcher.AFTER_GATEWAY_SWITCH.notifyObservers();
            }
            return mobileSso.get();
        }
    }

    private static boolean isSwitchGateway(JSONObject newConfig) {
        try {
            Server current = ConfigurationManager.getInstance().getConnectedGateway();
            return !current.equals(new Server(newConfig));
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        AtomicReference<MobileSso> atomicReference = mobileSso;
        synchronized (atomicReference) {
            mobileSso.set(null);
            try {
                StorageProvider.getInstance().reset();
                ConfigurationManager.getInstance().reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static MobileSso createMobileSso(Context context) {
        final Context applicationContext = context.getApplicationContext();
        final MssoContext mssoContext = MssoContext.newContext();
        mssoContext.init(applicationContext);
        mssoContext.initPolicyManager();
        final MssoClient mssoClient = new MssoClient(mssoContext, applicationContext);
        final BluetoothLePeripheral bleServer = BluetoothLePeripheral.getInstance();
        bleServer.init(mssoContext.getConfigurationProvider(), applicationContext);
        return new MobileSso(){

            @Override
            public long processRequest(MASRequest request, ResultReceiver resultReceiver) {
                return mssoClient.processRequest(request, resultReceiver);
            }

            @Override
            public void logout(boolean contactServer) {
                mssoContext.logout(contactServer);
            }

            @Override
            public void destroyAllPersistentTokens() {
                EventDispatcher.RESET_LOCALLY.notifyObservers();
                mssoContext.destroyAllPersistentTokens();
            }

            @Override
            public void removeDeviceRegistration() {
                mssoContext.removeDeviceRegistration();
                mssoContext.destroyPersistentTokens();
            }

            @Override
            public boolean isLogin() {
                return mssoContext.isLogin();
            }

            @Override
            public boolean isDeviceRegistered() {
                return mssoContext.isDeviceRegistered();
            }

            @Override
            public ConfigurationProvider getConfigurationProvider() {
                return mssoContext.getConfigurationProvider();
            }

            @Override
            public void authorize(String url, ResultReceiver resultReceiver) {
                MASRequest.MASRequestBuilder builder;
                try {
                    if (url == null || url.trim().length() == 0) {
                        throw new IllegalArgumentException("Authorization request cannot be empty.");
                    }
                    try {
                        JSONObject jsonObject = new JSONObject(url);
                        String providerUrl = jsonObject.getString("provider_url");
                        if (resultReceiver instanceof AuthResultReceiver) {
                            ((AuthResultReceiver)resultReceiver).setData(jsonObject);
                        }
                        builder = new MASRequest.MASRequestBuilder(this.getURI(providerUrl));
                    }
                    catch (JSONException e) {
                        builder = new MASRequest.MASRequestBuilder(this.getURI(url));
                    }
                }
                catch (Exception e) {
                    if (resultReceiver != null) {
                        Bundle result = new Bundle();
                        result.putSerializable("com.ca.mas.core.service.result.error", (Serializable)new MAGError(e));
                        result.putString("com.ca.mas.core.service.result.errorMessage", e.getMessage());
                        resultReceiver.send(3, result);
                    }
                    return;
                }
                this.processRequest(builder.build(), resultReceiver);
            }

            @Override
            public void startBleSessionSharing(BluetoothLePeripheralCallback client) {
                bleServer.start(client);
            }

            @Override
            public void stopBleSessionSharing() {
                bleServer.stop();
            }

            @Override
            public URI getURI(String relativePath) {
                return mssoContext.getConfigurationProvider().getUri(relativePath);
            }

            @Override
            public String getPrefix() {
                return mssoContext.getConfigurationProvider().getPrefix();
            }

            @Override
            public AuthenticationProvider getAuthenticationProvider() throws Exception {
                return new OAuthClient(mssoContext).getSocialPlatformProvider(applicationContext);
            }

            @Override
            public void authenticate(MASAuthCredentials credentials, MAGResultReceiver<JSONObject> resultReceiver) {
                mssoClient.authenticate(credentials, resultReceiver);
            }

            @Override
            public void processPendingRequests() {
                mssoClient.processPendingRequests();
            }

            @Override
            public void cancelRequest(long requestId, Bundle data) {
                mssoClient.cancelRequest(requestId, data);
            }

            @Override
            public void cancelAllRequests(Bundle data) {
                mssoClient.cancelAll(data);
            }
        };
    }
}

