/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation.auth;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.auth.NFCRenderer;
import com.ca.mas.core.auth.NfcResultReceiver;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.service.Provider;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.auth.MASAuthenticationProvider;
import com.ca.mas.foundation.auth.MASAuthenticationProviders;
import com.ca.mas.foundation.auth.MASProximityLogin;
import com.ca.mas.foundation.notify.Callback;
import java.io.IOException;
import java.util.UUID;
import org.json.JSONException;

public class MASProximityLoginNFC
extends NFCRenderer
implements MASProximityLogin {
    public static void authorize(String authenticateUrl, final MASCallback<Void> callback) {
        MobileSsoFactory.getInstance().authorize(authenticateUrl, new NfcResultReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(MAGResponse response) {
                String address;
                String uuid;
                try {
                    if (this.getData() == null) {
                        if (MAS.DEBUG) {
                            Log.w((String)MAS.TAG, (String)"A Json message is expected for NFCResultReceiver.");
                        }
                        Callback.onError(callback, new IllegalArgumentException("A Json message is expected for NFCResultReceiver."));
                        return;
                    }
                    uuid = this.getData().getString("uuid");
                    address = this.getData().getString("address");
                }
                catch (JSONException e) {
                    if (MAS.DEBUG) {
                        Log.w((String)MAS.TAG, (String)"Invalid Json message from NFC Session Sharing", (Throwable)e);
                    }
                    Callback.onError(callback, e);
                    return;
                }
                BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                if (adapter != null) {
                    adapter.cancelDiscovery();
                    BluetoothDevice device = adapter.getRemoteDevice(address);
                    BluetoothSocket socket = null;
                    try {
                        socket = device.createInsecureRfcommSocketToServiceRecord(java.util.UUID.fromString(uuid));
                        socket.connect();
                    }
                    catch (Exception e) {
                        if (MAS.DEBUG) {
                            Log.d((String)MAS.TAG, (String)("Failed to send acknowledgement to NFC Bluetooth Service. " + e.getMessage()));
                        }
                    }
                    finally {
                        block20: {
                            if (socket != null) {
                                try {
                                    socket.close();
                                }
                                catch (IOException e) {
                                    if (!MAS.DEBUG) break block20;
                                    Log.d((String)MAS.TAG, (String)("Failed to close NFC Bluetooth Service Socket. " + e.getMessage()));
                                }
                            }
                        }
                    }
                }
                Callback.onSuccess(callback, null);
            }

            @Override
            public void onError(MAGError error) {
                Callback.onError(callback, error);
            }

            @Override
            public void onRequestCancelled(Bundle data) {
            }
        });
    }

    @Override
    public boolean init(Activity activity, long requestId, MASAuthenticationProviders providers) {
        this.requestId = requestId;
        for (MASAuthenticationProvider p : providers.getProviders()) {
            if (!p.isProximityLogin()) continue;
            return super.init((Context)activity, new Provider(p.getIdentifier(), p.getAuthenticationUrl(), p.getPollUrl(), null));
        }
        return false;
    }

    @Override
    public View render() {
        return super.render();
    }

    @Override
    public void start() {
        super.onRenderCompleted();
    }

    @Override
    public void stop() {
        super.close();
    }

    @Override
    public void onError(int errorCode, String m, Exception e) {
    }
}

