/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.util.Pair;
import com.ca.mas.core.http.ContentType;
import com.ca.mas.core.http.MAGRequestBody;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASClaims;
import com.ca.mas.foundation.MASClaimsBuilder;
import com.ca.mas.foundation.MASException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.util.List;
import org.json.JSONObject;

public abstract class MASRequestBody
extends MAGRequestBody {
    public static MASRequestBody byteArrayBody(byte[] body) {
        return MASRequestBody.transform(MAGRequestBody.byteArrayBody(body));
    }

    public static MASRequestBody stringBody(String body) {
        return MASRequestBody.transform(MAGRequestBody.stringBody(body));
    }

    public static MASRequestBody jsonBody(JSONObject jsonObject) {
        return MASRequestBody.transform(MAGRequestBody.jsonBody(jsonObject));
    }

    public static MASRequestBody urlEncodedFormBody(List<? extends Pair<String, String>> form) {
        return MASRequestBody.transform(MAGRequestBody.urlEncodedFormBody(form));
    }

    static MASRequestBody jwtClaimsBody(final MASClaims claims, final PrivateKey privateKey, final MAGRequestBody body) {
        return new MASRequestBody(){

            @Override
            public ContentType getContentType() {
                return ContentType.TEXT_PLAIN;
            }

            @Override
            public long getContentLength() {
                return -1L;
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                MASClaimsBuilder builder = new MASClaimsBuilder(claims);
                builder.claim("content", body.getContentAsJsonValue());
                if (body.getContentType() != null) {
                    builder.claim("content-type", body.getContentType().getMimeType());
                }
                MASClaims masClaims = builder.build();
                String compactJws = null;
                try {
                    compactJws = privateKey == null ? MAS.sign(masClaims) : MAS.sign(masClaims, privateKey);
                }
                catch (MASException e) {
                    throw new IOException(e);
                }
                outputStream.write(compactJws.getBytes(this.getContentType().getCharset()));
            }
        };
    }

    private static MASRequestBody transform(final MAGRequestBody requestBody) {
        return new MASRequestBody(){

            @Override
            public ContentType getContentType() {
                return requestBody.getContentType();
            }

            @Override
            public long getContentLength() {
                return requestBody.getContentLength();
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                requestBody.write(outputStream);
            }

            @Override
            public Object getContentAsJsonValue() {
                return requestBody.getContentAsJsonValue();
            }
        };
    }
}

