/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.io.IoUtils;
import com.ca.mas.foundation.MASAuthCredentials;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MASAuthCredentialsPassword
implements MASAuthCredentials {
    private final String username;
    private volatile char[] password;
    public static final Parcelable.Creator<MASAuthCredentialsPassword> CREATOR = new Parcelable.Creator<MASAuthCredentialsPassword>(){

        public MASAuthCredentialsPassword createFromParcel(Parcel in) {
            return new MASAuthCredentialsPassword(in);
        }

        public MASAuthCredentialsPassword[] newArray(int size) {
            return new MASAuthCredentialsPassword[size];
        }
    };

    public MASAuthCredentialsPassword(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    private MASAuthCredentialsPassword(Parcel in) {
        this.username = in.readString();
        this.password = new char[in.readInt()];
        in.readCharArray(this.password);
    }

    private void clearPassword() {
        char[] p = this.password;
        this.password = null;
        if (p != null) {
            Arrays.fill(p, 'X');
        }
    }

    @Override
    public void clear() {
        this.clearPassword();
    }

    @Override
    public boolean isValid() {
        return this.username != null && this.password != null;
    }

    @Override
    public Map<String, List<String>> getHeaders(MssoContext context) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        ArrayList<String> authorizationValue = new ArrayList<String>();
        authorizationValue.add("Basic " + IoUtils.base64(this.username + ":" + new String(this.password), Charset.defaultCharset()));
        headers.put("authorization", authorizationValue);
        return headers;
    }

    @Override
    public List<Pair<String, String>> getParams(MssoContext config) {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(new Pair((Object)"username", (Object)this.username));
        params.add(new Pair((Object)"password", (Object)new String(this.password)));
        return params;
    }

    @Override
    public String getGrantType() {
        return "password";
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean canRegisterDevice() {
        return true;
    }

    public String toString() {
        return this.username;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.username);
        dest.writeInt(this.password.length);
        dest.writeCharArray(this.password);
    }
}

