/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import com.ca.mas.foundation.MAS;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.security.auth.x500.X500Principal;

public class KeyUtilsAsymmetric {
    private static final String ANDROID_KEY_STORE = "AndroidKeyStore";
    private static final int MAX_CHAIN = 9;
    private static final String CIPHER_ENCRYPTION_ANDROID_PRE_M = "RSA/ECB/PKCS1Padding";
    private static final String CIPHER_ENCRYPTION_ANDROID_M_PLUS = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

    public static PrivateKey generateRsaPrivateKey(Context context, int keysize, String alias, String dn, boolean lollipopEncryptionRequired, boolean marshmallowUserAuthenticationRequired, int marshmallowUserAuthenticationValidityDurationSeconds, boolean nougatInvalidatedByBiometricEnrollment) throws InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException {
        if (keysize < 2048) {
            keysize = 2048;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return KeyUtilsAsymmetric.generateRsaPrivateKeyAndroidN(keysize, alias, dn, marshmallowUserAuthenticationRequired, marshmallowUserAuthenticationValidityDurationSeconds, nougatInvalidatedByBiometricEnrollment);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return KeyUtilsAsymmetric.generateRsaPrivateKeyAndroidM(keysize, alias, dn, marshmallowUserAuthenticationRequired, marshmallowUserAuthenticationValidityDurationSeconds);
        }
        return KeyUtilsAsymmetric.generateRsaPrivateKeyAndroidL(context, keysize, alias, dn, lollipopEncryptionRequired);
    }

    private static PrivateKey generateRsaPrivateKeyAndroidL(Context context, int keysize, String alias, String dn, boolean setEncryptionRequired) throws InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException {
        RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(keysize, RSAKeyGenParameterSpec.F4);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", ANDROID_KEY_STORE);
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        cal.add(1, 1);
        Date end = cal.getTime();
        if (setEncryptionRequired) {
            kpg.initialize((AlgorithmParameterSpec)new KeyPairGeneratorSpec.Builder(context).setAlias(alias).setAlgorithmParameterSpec((AlgorithmParameterSpec)spec).setEncryptionRequired().setStartDate(now).setEndDate(end).setSerialNumber(BigInteger.valueOf(1L)).setSubject(new X500Principal(dn)).build());
        } else {
            kpg.initialize((AlgorithmParameterSpec)new KeyPairGeneratorSpec.Builder(context).setAlias(alias).setAlgorithmParameterSpec((AlgorithmParameterSpec)spec).setStartDate(now).setEndDate(end).setSerialNumber(BigInteger.valueOf(1L)).setSubject(new X500Principal(dn)).build());
        }
        return kpg.generateKeyPair().getPrivate();
    }

    @TargetApi(value=23)
    private static PrivateKey generateRsaPrivateKeyAndroidM(int keysize, String alias, String dn, boolean userAuthenticationRequired, int userAuthenticationValidityDurationSeconds) throws InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", ANDROID_KEY_STORE);
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        cal.add(1, 1);
        Date end = cal.getTime();
        keyPairGenerator.initialize((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(alias, 15).setKeySize(keysize).setCertificateNotBefore(now).setCertificateNotAfter(end).setCertificateSubject(new X500Principal("CN=msso")).setCertificateSerialNumber(BigInteger.valueOf(1L)).setUserAuthenticationRequired(userAuthenticationRequired).setUserAuthenticationValidityDurationSeconds(userAuthenticationValidityDurationSeconds).setRandomizedEncryptionRequired(false).setBlockModes(new String[]{"CBC", "CTR", "ECB", "GCM"}).setDigests(new String[]{"NONE", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"}).setEncryptionPaddings(new String[]{"PKCS7Padding", "OAEPPadding", "PKCS1Padding"}).setSignaturePaddings(new String[]{"PSS", "PKCS1"}).build());
        return keyPairGenerator.generateKeyPair().getPrivate();
    }

    @TargetApi(value=24)
    private static PrivateKey generateRsaPrivateKeyAndroidN(int keysize, String alias, String dn, boolean userAuthenticationRequired, int userAuthenticationValidityDurationSeconds, boolean invalidatedByBiometricEnrollment) throws InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", ANDROID_KEY_STORE);
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        cal.add(1, 1);
        Date end = cal.getTime();
        keyPairGenerator.initialize((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(alias, 15).setKeySize(keysize).setCertificateNotBefore(now).setCertificateNotAfter(end).setCertificateSubject(new X500Principal("CN=msso")).setCertificateSerialNumber(BigInteger.valueOf(1L)).setUserAuthenticationRequired(userAuthenticationRequired).setUserAuthenticationValidityDurationSeconds(userAuthenticationValidityDurationSeconds).setInvalidatedByBiometricEnrollment(invalidatedByBiometricEnrollment).setRandomizedEncryptionRequired(false).setBlockModes(new String[]{"CBC", "CTR", "ECB", "GCM"}).setDigests(new String[]{"NONE", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"}).setEncryptionPaddings(new String[]{"PKCS7Padding", "OAEPPadding", "PKCS1Padding"}).setSignaturePaddings(new String[]{"PSS", "PKCS1"}).build());
        return keyPairGenerator.generateKeyPair().getPrivate();
    }

    public static Key getKeystoreKey(String alias) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
        keyStore.load(null);
        return keyStore.getKey(alias, null);
    }

    public static PrivateKey getRsaPrivateKey(String alias) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        return (PrivateKey)KeyUtilsAsymmetric.getKeystoreKey(alias);
    }

    public static PublicKey getRsaPublicKey(String alias) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
        keyStore.load(null);
        Certificate cert = keyStore.getCertificate(alias);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public static void deletePrivateKey(String alias) {
        block2: {
            try {
                KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
                keyStore.load(null);
                keyStore.deleteEntry(alias);
            }
            catch (Exception e) {
                if (!MAS.DEBUG) break block2;
                Log.e((String)MAS.TAG, (String)("Unable delete private key: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void setCertificateChain(String aliasPrefix, X509Certificate[] chain) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        int i;
        KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
        keyStore.load(null);
        for (i = 1; i <= 9; ++i) {
            keyStore.deleteEntry(aliasPrefix + i);
        }
        for (i = 0; i < chain.length; ++i) {
            keyStore.setCertificateEntry(aliasPrefix + (i + 1), chain[i]);
        }
    }

    public static X509Certificate[] getCertificateChain(String aliasPrefix) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        X509Certificate[] returnChain = null;
        KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
        keyStore.load(null);
        int numInChain = 0;
        Enumeration<String> e = keyStore.aliases();
        while (e.hasMoreElements()) {
            int numAlias;
            String aliasFound = e.nextElement();
            if (!aliasFound.startsWith(aliasPrefix) || (numAlias = Integer.parseInt(aliasFound.replace(aliasPrefix, ""))) <= numInChain) continue;
            numInChain = numAlias;
        }
        if (numInChain > 0) {
            returnChain = new X509Certificate[numInChain];
            for (int i = 0; i < numInChain; ++i) {
                returnChain[i] = (X509Certificate)keyStore.getCertificate(aliasPrefix + (i + 1));
            }
        }
        return returnChain;
    }

    public static void clearCertificateChain(String aliasPrefix) {
        block3: {
            try {
                KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE);
                keyStore.load(null);
                for (int i = 1; i <= 9; ++i) {
                    keyStore.deleteEntry(aliasPrefix + i);
                }
            }
            catch (Exception e) {
                if (!MAS.DEBUG) break block3;
                Log.e((String)MAS.TAG, (String)("Unable to clear certificate chain: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static byte[] encryptSection(PublicKey publicKey, byte[] contentToEncrypt) throws NoSuchPaddingException, InvalidKeyException, InvalidParameterException, BadPaddingException, BadPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        Cipher cipher = null;
        if (Build.VERSION.SDK_INT < 23) {
            cipher = Cipher.getInstance(CIPHER_ENCRYPTION_ANDROID_PRE_M);
            cipher.init(1, publicKey);
        } else {
            cipher = Cipher.getInstance(CIPHER_ENCRYPTION_ANDROID_M_PLUS);
            cipher.init(1, (Key)publicKey, new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT));
        }
        byte[] encryptedBytes = cipher.doFinal(contentToEncrypt);
        return encryptedBytes;
    }

    public static byte[] decryptSection(PrivateKey privateKey, byte[] contentToDecrypt) throws NoSuchPaddingException, InvalidKeyException, InvalidParameterException, BadPaddingException, BadPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, IllegalArgumentException, InvalidAlgorithmParameterException {
        Cipher cipher;
        if (Build.VERSION.SDK_INT < 23) {
            cipher = Cipher.getInstance(CIPHER_ENCRYPTION_ANDROID_PRE_M);
            cipher.init(2, privateKey);
        } else {
            cipher = Cipher.getInstance(CIPHER_ENCRYPTION_ANDROID_M_PLUS);
            cipher.init(2, (Key)privateKey, new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT));
        }
        byte[] decryptedBytes = cipher.doFinal(contentToDecrypt);
        return decryptedBytes;
    }

    public static byte[] decrypt(PrivateKey privateKey, int keysize, byte[] contentToDecrypt) throws NoSuchPaddingException, InvalidKeyException, InvalidParameterException, BadPaddingException, BadPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        int encryptedSize = 256;
        ArrayList<byte[]> encryptedParts = KeyUtilsAsymmetric.arraySplit(contentToDecrypt, encryptedSize);
        ArrayList<byte[]> decrypted = new ArrayList<byte[]>();
        for (byte[] bytesToDecrypt : encryptedParts) {
            byte[] decryptedBytes = KeyUtilsAsymmetric.decryptSection(privateKey, bytesToDecrypt);
            decrypted.add(decryptedBytes);
        }
        byte[] bytesDecrypted = KeyUtilsAsymmetric.arrayConcat(decrypted);
        return bytesDecrypted;
    }

    public static byte[] encrypt(PublicKey publicKey, int keysize, byte[] contentToEncrypt) throws NoSuchPaddingException, InvalidKeyException, InvalidParameterException, BadPaddingException, BadPaddingException, NoSuchAlgorithmException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        int encryptedSize = 256;
        int originalChunk = 128;
        ArrayList<byte[]> original = KeyUtilsAsymmetric.arraySplit(contentToEncrypt, originalChunk);
        ArrayList<byte[]> encrypted = new ArrayList<byte[]>();
        for (byte[] bytesToEncrypt : original) {
            byte[] encryptedBytes = KeyUtilsAsymmetric.encryptSection(publicKey, bytesToEncrypt);
            encrypted.add(encryptedBytes);
        }
        byte[] bytesEncryptedFull = KeyUtilsAsymmetric.arrayConcat(encrypted);
        return bytesEncryptedFull;
    }

    protected static byte[] arrayConcat(ArrayList<byte[]> byteArrayList) {
        int lengthTotal = 0;
        for (byte[] byteArray : byteArrayList) {
            lengthTotal += byteArray.length;
        }
        byte[] result = new byte[lengthTotal];
        int lengthCurrent = 0;
        for (byte[] byteArray : byteArrayList) {
            System.arraycopy(byteArray, 0, result, lengthCurrent, byteArray.length);
            lengthCurrent += byteArray.length;
        }
        return result;
    }

    protected static ArrayList<byte[]> arraySplit(byte[] bytes, int eachLength) {
        int lengthCurrent;
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int lengthTotal = 0; lengthTotal < bytes.length; lengthTotal += lengthCurrent) {
            lengthCurrent = bytes.length - lengthTotal;
            if (lengthCurrent > eachLength) {
                lengthCurrent = eachLength;
            }
            byte[] section = new byte[lengthCurrent];
            System.arraycopy(bytes, lengthTotal, section, 0, lengthCurrent);
            result.add(section);
        }
        return result;
    }

    protected KeyUtilsAsymmetric() {
    }
}

