/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.store;

import android.util.Log;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.core.context.MssoException;
import com.ca.mas.core.datasource.DataSource;
import com.ca.mas.core.datasource.DataSourceException;
import com.ca.mas.core.datasource.DataSourceFactory;
import com.ca.mas.core.datasource.KeystoreDataSource;
import com.ca.mas.core.datasource.StringDataConverter;
import com.ca.mas.core.store.ClientCredentialContainer;
import com.ca.mas.core.store.ClientCredentialStorage;
import com.ca.mas.core.store.DefaultTokenManager;
import com.ca.mas.core.store.OAuthTokenContainer;
import com.ca.mas.core.store.PrivateTokenStorage;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.foundation.MAS;
import org.json.JSONException;
import org.json.JSONObject;

public class StorageProvider {
    private StorageConfig mStorageConfig;
    private TokenManager tokenManager;
    private OAuthTokenContainer oAuthTokenContainer;
    private ClientCredentialContainer clientCredentialContainer;
    private static StorageProvider instance;

    private StorageProvider(ConfigurationProvider configurationProvider) {
        this.mStorageConfig = new StorageConfig(configurationProvider);
        this.tokenManager = this.createTokenManager();
        this.oAuthTokenContainer = this.createOAuthTokenContainer();
        this.clientCredentialContainer = this.createClientCredentialContainer();
    }

    public static synchronized StorageProvider getInstance() {
        if (instance == null) {
            if (ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider() == null) {
                throw new IllegalStateException("ConfigurationManager not initialized.");
            }
            instance = new StorageProvider(ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider());
        }
        return instance;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public OAuthTokenContainer getOAuthTokenContainer() {
        return this.oAuthTokenContainer;
    }

    public ClientCredentialContainer getClientCredentialContainer() {
        return this.clientCredentialContainer;
    }

    public void reset() {
        instance = null;
    }

    private TokenManager createTokenManager() {
        ConfigurationProvider provider = ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider();
        String tm = (String)provider.getProperty("msso.share.token.manager");
        if (tm == null) {
            JSONObject params;
            block3: {
                params = new JSONObject();
                try {
                    params = new JSONObject(this.mStorageConfig.getStorageConfig().toString());
                    params.put("share", (Object)Boolean.TRUE);
                }
                catch (JSONException e) {
                    if (!MAS.DEBUG) break block3;
                    Log.w((String)MAS.TAG, (String)("failed to set sharing property " + (Object)((Object)e)));
                }
            }
            DataSource storage = DataSourceFactory.getStorage(ConfigurationManager.getInstance().getContext(), this.mStorageConfig.getStorageClass(), params, null);
            return new DefaultTokenManager(storage);
        }
        return (TokenManager)this.create(tm);
    }

    private OAuthTokenContainer createOAuthTokenContainer() {
        String pt = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.private.token.manager");
        if (pt == null) {
            DataSource storage = DataSourceFactory.getStorage(ConfigurationManager.getInstance().getContext(), this.mStorageConfig.getStorageClass(), this.mStorageConfig.getStorageConfig(), new StringDataConverter());
            return new PrivateTokenStorage(storage);
        }
        return (OAuthTokenContainer)this.create(pt);
    }

    private ClientCredentialContainer createClientCredentialContainer() {
        String cc = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.client.credential.manager");
        if (cc == null) {
            DataSource storage = DataSourceFactory.getStorage(ConfigurationManager.getInstance().getContext(), this.mStorageConfig.getStorageClass(), this.mStorageConfig.getStorageConfig(), new StringDataConverter());
            return new ClientCredentialStorage(storage);
        }
        return (ClientCredentialContainer)this.create(cc);
    }

    private Object create(String c) {
        try {
            Object o = Class.forName(c).newInstance();
            return o;
        }
        catch (Exception e) {
            throw new MssoException(e);
        }
    }

    public boolean hasValidStore() {
        DataSource temp = DataSourceFactory.getStorage(ConfigurationManager.getInstance().getContext(), this.mStorageConfig.getStorageClass(), this.mStorageConfig.getStorageConfig(), new StringDataConverter());
        return temp != null && temp.isReady();
    }

    private static class StorageConfig {
        Class storageClass;
        JSONObject storageConfig = new JSONObject();
        static String PROP_STORAGE_CLASS = "class";
        static final String PROP_SHARE_STATUS = "share";

        StorageConfig(ConfigurationProvider configurationProvider) {
            JSONObject storageJson = (JSONObject)configurationProvider.getProperty("msso.storage");
            if (storageJson == null) {
                if (MAS.DEBUG) {
                    Log.d((String)MAS.TAG, (String)"No storage configuration found in JSON config, falling back to DEFAULT ");
                }
                this.storageClass = KeystoreDataSource.class;
                this.storageConfig = new JSONObject();
            } else {
                try {
                    this.storageClass = Class.forName("" + storageJson.get(PROP_STORAGE_CLASS));
                    this.storageConfig = storageJson;
                }
                catch (ClassNotFoundException e) {
                    throw new DataSourceException(String.format("Provided Storage configuration %s cannot be found ", storageJson.toString()), e);
                }
                catch (JSONException e) {
                    throw new DataSourceException("Invalid Storage Config", e);
                }
            }
        }

        Class getStorageClass() {
            return this.storageClass;
        }

        JSONObject getStorageConfig() {
            return this.storageConfig;
        }
    }
}

